/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"long_char.h"
#include	"lc_encode.h"
#include	"text_render.h"

TR_ERROR
make_black_box_render(TR_SEQUENCE * ,TR_CHAR_INFO *);

TR_LANG black_box_render = {
	"bb",
	VSD_ALL,0,
	0,
	0,
	0,
	make_black_box_render,
	0
};


TR_ERROR
make_black_box_render(TR_SEQUENCE * sq,TR_CHAR_INFO * ci)
{
TR_LANG_LINE * ll;
int dir;
TR_ERROR e;
	ll = _tr_prev_lang_line(ci->lang_line);
	if ( ll == 0 )
		dir = ci->box_line->attr.default_dir;
	else	dir = ll->dir;
	ci->lang_line->dir = dir;
	(*sq->box_op->start_lang_line_op)(sq,ci);
	e = (*sq->box_op->put_box_line)
		(sq,ci,ci->p,&ci->p.buf->element_buf[ci->p.ptr]);
	switch ( e.code ) {
	case TRE_OK:
		ci->lang_line->end = tr_ptr_next(ci->lang_line->start);
		break;
	case TRE_INSERT_CHAR:
		e.code = TRE_OK;
		ci->lang_line->end = ci->lang_line->start;
		e.subcode = TRE_OK_NEW_LINE;
		break;
	case TRE_INSERT_LINE:
		break;
	default:
		er_panic("make_black_box");
	}
	return _tr_stop_lang_line_op(e,sq,ci);
}


