/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_RING_H____
#define VPF_RING_H____

#include "vpf_types.h"
#include "vpf_table.h"
#include "vpf_file.h"


typedef struct{
	LONG id;
	LONG face_id;
	LONG start_edge;
}VPF_RING_RECORD;

int ring_record_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
void ring_record_delete(VPF_RING_RECORD *ring);
VPF_RING_RECORD *vpf_table_get_ring(VPF_TABLE *ring_table, LONG id);
void vpf_table_get_rings_by_faceid(VPF_LIST *ret, const VPF_TABLE *ring_table, LONG faceid);

#endif

