/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef __ARC_DATA_H__
#define __ARC_DATA_H__

/* Σ쥳 */
typedef struct arc_id_record{
	char code[32]; 
	int kind;
	int id;           
	int point_count;
	GB_POINT *points; 
	int flags; /* ǡξ֤򼨤ե饰(Ǥ˷˻Ѥ줿ɤΥե饰ʤɤ򥻥å) */
#define AF_NOTFINDFORJOIN  1
#define AF_INVERTFORJOIN   2
#define AF_REMOVED		   4
} ARC_ID_RECORD;

/* ɣĥ쥳ɤޤȤ᤿ǡ */
/* ե */
typedef struct arc_data{
	KIBAN_FILE_HEADER header;
	ARC_ID_RECORD *record; /*Υ쥳 */
} ARC_DATA;

/* 쥳 */
typedef struct arc_ref{
	int direction; /* 10 */
	int arc_id;    /* Σɣ */
} ARC_REF;


/* Ϥ */
int PrintArc(FILE *fp, ARC_ID_RECORD *pArcID, int bDirection, int nOption);
/* ǡեɤ߹ */
int ReadArc(const char *filename, FILE *fp, ARC_DATA *pData, int Flags);
/* ǡSVGǤФ */
void ArcData2SVG(FILE *fp, ARC_DATA *pArc, const char *szStrokeColor);
/* ID쥳ɤ򸡺 */
ARC_ID_RECORD *GetArcIDRecord(ARC_DATA *pArc, int nArcID);

ARC_DATA *malloc_arc_data();
void free_ark_id_record(ARC_ID_RECORD *pRecord);
void free_arc_data(ARC_DATA *pData);

#endif
