/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"



XL_SEXP *
xl_mxSaveSB(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxSaveSB(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxSaveSB"),
		get_func_prim(xl_mxSaveSB,FO_APPLICATIVE,0,1,1));
}


XL_SEXP *
xl_mxSaveSB(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int ch;
MATRIX_TOKEN * t;
MATRIX * m;
MATRIX_NODE * n;
int ret;
//char * e_param;
MATRIX_ALLOC_BLOCK_PARAM * p;
MATRIX_DATA_TYPE * md;
	t = get_env_work(env);
	n = t->process_node;
	m = n->matrix;
	matrix_node_channel_lock(n);
	if ( n->channel == 0 ) {
		n->channel = d_alloc(sizeof(MATRIX_CHANNEL)*m->p.channel_nos);
		memset(n->channel,0,sizeof(MATRIX_CHANNEL)*m->p.channel_nos);
	}
	for ( ch = 0 ; ch < m->p.channel_nos ; ch ++ ) {
		if ( m->channel_info[ch].data_type != &mx_type_block )
			continue;
		if ( n->channel[ch].sb == 0 )
			continue;
		md = m->channel_info[ch].data_type;
		p = (*n->channel[ch].sb->tbl->struct2block)(n->channel[ch].sb);
		if ( p == 0 ) {
			matrix_node_channel_unlock(n,0);
			goto inv_param2;
		}
		if ( n->channel[ch].data == 0 ) {
			n->channel[ch].data = p;
			if ( m->channel_info[ch].flags & MF_FILE )
				_set_dirty_file(n);
		}
		else {
			switch ( (*md->cmp)(md,p,n->channel[ch].data) ) {
			case -2:
				(*md->free_data)(md,p);
				ret = -2;
				matrix_node_channel_unlock(n,0);
				goto inv_param2;
			case -1:
			case 1:
				(*md->free_data)(md,n->channel[ch].data);
				n->channel[ch].data = p;
				if ( m->channel_info[ch].flags & MF_FILE )
					_set_dirty_file(n);
				break;
			case 0:
				(*md->free_data)(md,p);
				break;
			default:
				er_panic("_set_channel_sexp");
			}
		}
	}
	matrix_node_channel_unlock(n,0);
	return 0;
/*
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxSaveSB"),
		List(n_get_string("invalid parameter in mxSaveSB"),
			n_get_string(e_param),-1));
*/
inv_param2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxSaveSB"),
		List(n_get_string("invalid parameter in mxSaveSB"),
			get_integer(ret,0),-1));
}

