/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"memory_debug.h"
#include	"xl.h"
#include	"xl2pdb_p.h"



XL_SEXP * xl_padding_color();

void
init_padding_color(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"padding-color"),
		get_func_prim(xl_padding_color,FO_APPLICATIVE,0,2,5));
}

XL_SEXP *
pdb_color(GB_COLOR * cl,XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int len;
XL_SEXP * lst;
XL_SEXP * r,* g,* b,*t;
int len2;
char* e_param;

	len = list_length(s);
	if ( len != 2 && len != 5 )
		goto invalid_list_length;
	if ( len == 2 ) {
		lst = get_el(s,1);
		if ( get_type(lst) != XLT_PAIR ) {
			e_param = "1st";
			goto type_missmatch;
		}
		len2 = list_length(lst);
		if ( len2 < 0 )
			return list_error(lst);
		if ( len2 != 4 )
			goto invalid_list_length_of_param;
		r = get_el(lst,0);
		g = get_el(lst,1);
		b = get_el(lst,2);
		t = get_el(lst,3);
	}
	else {
		r = get_el(s,1);
		g = get_el(s,2);
		b = get_el(s,3);
		t = get_el(s,4);
	}
	switch ( get_type(r) ) {
	case XLT_INTEGER:
		cl->r = r->integer.data;
		break;
	case XLT_FLOAT:
		cl->r = r->floating.data;
		break;
	default:
		e_param = "Read";
		goto type_missmatch;
	}
	switch ( get_type(g) ) {
	case XLT_INTEGER:
		cl->g = g->integer.data;
		break;
	case XLT_FLOAT:
		cl->g = g->floating.data;
		break;
	default:
		e_param = "Green";
		goto type_missmatch;
	}
	switch ( get_type(b) ) {
	case XLT_INTEGER:
		cl->b = b->integer.data;
		break;
	case XLT_FLOAT:
		cl->b = b->floating.data;
		break;
	default:
		e_param = "Blue";
		goto type_missmatch;
	}
	switch ( get_type(t) ) {
	case XLT_INTEGER:
		cl->t = t->integer.data;
		break;
	case XLT_FLOAT:
		cl->t = t->floating.data;
		break;
	default:
		e_param = "Alpha Cannel";
		goto type_missmatch;
	}
	if ( cl->r < 0 || cl->r > 1 ||
			cl->g < 0 || cl->g > 1 ||
			cl->b < 0 || cl->b > 1 ||
			cl->t < 0 || cl->t > 1 ) {
		e_param = "RGB value";
		goto invalid_param;
	}
	return 0;
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"color cmd"),
			List(n_get_string("ivalid parameter"),
				n_get_string(e_param),
				-1));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"color cmd"),
			List(n_get_string("type missmatch"),
				n_get_string(e_param),
				-1));
invalid_list_length:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_PARAM_LENGTH,
		l_string(std_cm,"color cmd"),
			List(n_get_string("invalid parameter length"),
				-1));
invalid_list_length_of_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"color cmd"),
			List(n_get_string("invalid length of RGB value"),
				-1));
}

XL_SEXP *
xl_padding_color(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
PDB_POLYGON2D * p;
XL_SEXP * ret;
	p = get_polygon(&ret,sf,s->h.file,s->h.line);
	if ( p == 0 )
		return ret;
	return pdb_color(&p->padding,env,s,a,sf);
}
