/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"v/v_authentification.h"

extern "C" {
#include	"win_flame.h"
}

typedef struct v_auth_work {
	RESOURCE *		r;
	AUTH_RESULT **		result_ary;
	XL_SEXP **		sexp_ary;
	int			ary_nos;
} V_AUTH_WORK;

void
authentification_pre_func(DIALOG_IO * io,XL_SEXP * s);
void
authentification_post_func(DIALOG_IO * io,XL_SEXP * s);

void
authentification_pre_func(DIALOG_IO * io,XL_SEXP * s)
{
XL_SEXP * id;
VObject * listing_obj;
RESOURCE * r;
LOAD_RESOURCE_SERVICE_CODE * cl,*clp;
AUTH_RESULT * res;
XLISP_ENV * env;
XL_SEXP * ret;
V_AUTH_WORK * w;
int nos;
int i;
XL_SEXP * dt;
	id = vobj_get_object_by_name(s,l_string(std_cm,"authentification-list"),0);
	if ( get_type(id) != XLT_INTEGER )
		return;
	listing_obj = VObject::get_object_by_id(id->integer.data);
	if ( listing_obj == 0 )
		return;
	w = (V_AUTH_WORK*)io->work;
	r = w->r;
	cl = 0;
	copy_insert_lw_service_code(&cl,r->h.auth_service_code,1);
//	copy_delete_lw_service_code(&cl,r);
	nos = 0;
	for ( clp = cl ; clp ; clp = clp->next , nos ++ );
	w->ary_nos = nos;
	w->result_ary = (AUTH_RESULT**)d_alloc(sizeof(AUTH_RESULT*)*nos);
	w->sexp_ary = (XL_SEXP**)d_alloc(sizeof(XL_SEXP*)*nos);
	i = 0;
	for ( clp = cl ; clp ; clp = clp->next , i ++ ) {
		res = search_auth_result_in_client(clp->service,clp->type,ARS_DENY,ARS_SEND_PERMIT|ARS_NOT_USE);
		if ( res == 0 ) {
			w->result_ary[i] = 0;
			w->sexp_ary[i] = 0;
			continue;
		}
		gc_push(0,0,"authentification_pre_func");
		env = new_env(vobj_env);
		set_env(env,l_string(std_cm,"__parent"),id);
		ret = eval(env,List(n_get_symbol(res->h.service->h.tbl->name),
					get_integer(i,0),
					List(n_get_symbol("quote"),
						(dt=(*res->h.service->h.tbl->send_result_info)(res)),
						-1),
					-1));
		w->sexp_ary[i] = ret;
		w->result_ary[i] = res;
		if ( get_type(ret) == XLT_ERROR ) {
			ss_printf("authentification_pre_func");
			print_sexp(s_stdout,ret,0);
			ss_printf("\n");
			ret = eval(env,List(n_get_symbol("authentification-unsupport"),
					get_integer(i,0),
					List(n_get_symbol("quote"),
						(*res->h.service->h.tbl->send_result_info)(res),
						-1),
					-1));
			ss_printf("authentification_pre_func-unsupport");
			print_sexp(s_stdout,ret,0);
			ss_printf("\n");
			
			w->sexp_ary[i] = 0;
		}
		gc_pop(ret,(void(*)())gc_gb_sexp);
	}
	free_lw_service_code(cl,0);
}


void
authentification_post_func(DIALOG_IO * io,XL_SEXP * s)
{
int i;
V_AUTH_WORK * w;
AUTH_RESULT * res;
XL_SEXP * id,* sv, * sym;
char ** mp;
VObjectStatus sts;
VObject * obj;
VExError err;
WFID_INCLUDE_RESOURCE * wir,* wirp;
LOAD_RESOURCE_SERVICE_CODE * cl;

	if ( io->ret != DIO_OK )
		return;
	w = (V_AUTH_WORK*)io->work;
	cl = 0;
	copy_delete_lw_service_code(&cl,w->r);
	free_lw_service_code(cl,0);
	for ( i = 0 ; i < w->ary_nos ; i ++ ) {
		res = w->result_ary[i];
		mp = (*res->h.service->h.tbl->get_result_members)(res);
		sv = (*res->h.service->h.tbl->send_result_info)(res);
		sym = car(sv);

		id = vobj_get_object_by_name(w->sexp_ary[i],l_string(std_cm,"auth-status"),0);
		if ( get_type(id) != XLT_INTEGER )
			continue;
		obj = VObject::get_object_by_id(id->integer.data);
		if ( obj == 0 )
			continue;
		memset(&sts,0,sizeof(sts));
		obj->get_status(&sts,VSF_VALUE);
		if ( sts.value == 0 ) {
			res->h.status = ARS_NONE;
		}
		else {
			res->h.status = ARS_SEND_PERMIT;
		}
		for ( ; *mp ; mp ++ ) {
			id = vobj_get_object_by_name(w->sexp_ary[i],l_string(std_cm,*mp),0);
			if ( get_type(id) != XLT_INTEGER )
				continue;
			obj = VObject::get_object_by_id(id->integer.data);
			if ( obj == 0 )
				continue;
			memset(&sts,0,sizeof(sts));
			err = obj->get_status(&sts,VSF_DESC);
			set_attribute(sym,l_string(std_cm,*mp),(L_CHAR*)sts.descriptor);
		}
		set_authentification_result(res,sv);
		(*res->h.service->h.tbl->free_auth_result)(res,0);
	}
	d_f_ree(w->result_ary);
	d_f_ree(w->sexp_ary);
	wf_auth_information(w->r);
	wir = wf_search_wfid_include_resource(w->r);
	for (wirp = wir ; wirp ; wirp = wirp->next ) {
		assert_ls(wirp->gf,LSF_ASSERT);
	}
	wf_insert_dirty_rect(w->r,&w->r->h.minrect,WFF_LUSTER_DIRTY|WFF_POLY_DIRTY,10,10);
	free_wfid_include_resource(wir);
}


void
authentification_dialog(RESOURCE * r)
{
DIALOG_IO io;
V_AUTH_WORK w;
	w.r = r;
	w.result_ary = 0;

	memset(&io,0,sizeof(io));
	io.msg[0] = ll_copy_str(get_url_str2(&r->h.entry));
	io.type = "modal-authentification";
	io.work = (void*)&w;
	io.pre_func = authentification_pre_func;
	io.post_func = authentification_post_func;
	gc_push(0,0,"authentification_dialog");
	v_modal_dialog(&io);
	gc_pop(0,0);
	d_f_ree(io.msg[0]);
}

