/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"v/v.h"
#include	"v/vobj_utils.h"


extern "C" {

#include	"task.h"
#include	"avt.h"
#include	"gbview.h"
#include	<string.h>
#include	"memory_debug.h"
#include	"xl.h"
#include	"gif.h"
#include	"xlerror.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"win_flame.h"


typedef struct ri_vdraw {
	VDraw *		obj;
	VImage *	errfile;
} RI_VDRAW;

extern "C" VImage * get_image_from_sf(XL_SEXP ** retp,XLISP_ENV * env,L_CHAR * filepath,
			XL_SYM_FIELD * sf);
void
set_vdraw_data(VDraw * obj,VImage*,void * data,int w,int h);
XL_SEXP *
vobj_VxlLoadingVDraw(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);


void
init_vobj_VxlLoadingVDraw(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VxlLoadingVDraw"),
		get_func_prim((XL_SEXP*(*)())vobj_VxlLoadingVDraw,FO_APPLICATIVE,0,3,3));
}


void
set_vdraw_data(VDraw * obj,VImage * img,void * data,int w,int h)
{
unsigned int * raw;
unsigned int cc;
int x,y;
unsigned int * src;
long int *dest;
VObjectStatus sts;
	if ( img ) {
		if ( obj->set_image(img) != V_ER_NO_ERR )
			er_panic("set_vdraw_data");
	}
	else {
		img = v_image_new(w,h,32);
		v_image_draw_start(img, 0);
		raw = (unsigned int*)data;
		src = raw;
		for ( y = 0 ; y < h ; y ++ ) {
			dest = &img->buf_32[img->w_border*y];
			for ( x = 0 ; x < w ; x ++ ) {
				cc = *src++;
				SET_RGB8_32(*dest,
					cc>>(COL_BIT-8),cc>>(COL_BIT*2-8),cc>>(COL_BIT*3-8),RGB8_MAX);
				dest++;
			}
		}
		v_image_draw_end(img);
		obj->set_image(img);
	}
	sts.min_size = sts.size = img->size;
	obj->set_status(&sts,VSF_SIZE|VSF_MIN_SIZE);
	obj->redraw();
}

int
vdraw_ri_func(int type,RI_QUEUE * rq,void * data)
{
RI_VDRAW * src;
RI_VDRAW * dest;
VObjectStatus sts;
VExError err;

	src = (RI_VDRAW*)data;
	switch ( type ) {
	case RICT_CALL:
		src = (RI_VDRAW*)rq->data;
		switch ( rq->ri->err ) {
		case RIE_OK:
			set_vdraw_data(src->obj,0,rq->ri->data,rq->ri->width,rq->ri->height);
			break;
		case RIE_ERR:
			set_vdraw_data(src->obj,src->errfile,0,0,0);
			break;
		default:
			er_panic("vdraw_ri_func");
		}
		return 0;
	case RICT_COPY:
		dest = (RI_VDRAW*)d_alloc(sizeof(RI_VDRAW));
		*dest = *src;
		if ( dest->errfile )
			v_image_ref(dest->errfile);
		rq->data = dest;
		return 0;
	case RICT_CMP:
		dest = (RI_VDRAW*)rq->data;
		if ( dest->obj != src->obj )
			return -1;
		return 0;
	case RICT_DELETE:
		dest = (RI_VDRAW*)rq->data;
		if ( dest->errfile )
			v_image_unref(dest->errfile);
		d_f_ree(rq->data);
		rq->data = 0;
		return 0;
		break;
	case RICT_TICK:
		src = (RI_VDRAW*)rq->data;
		memset(&sts,0,sizeof(sts));
		err = src->obj->get_status(&sts,VSF_ID);
		if ( err.code )
			return -1;
		return 0;
	default:
		er_panic("vdraw_ri_func");
		return 0;
	}
}

void
vdraw_get_ri(VImage * errfile,VDraw * obj,L_CHAR * path)
{
RI_VDRAW rg;
void * data;
int er;
int w,h;

	rg.obj = obj;
	rg.errfile = errfile;

	data = xl_get_ri(&er,&w,&h,vdraw_ri_func,&rg,path);
	switch ( er ) {
	case RIE_OK:
		set_vdraw_data(obj,0,data,w,h);
		break;
	case RIE_ERR:
		set_vdraw_data(obj,errfile,0,0,0);
		break;
	case RIE_REQ:
		break;
	default:
		er_panic("vdraw_get_ri");
	}
}




XL_SEXP *
vobj_VxlLoadingVDraw(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
/* arg
	obj_id
	access URL
	image="errfile"
*/
VDraw * obj;
XL_SEXP * obj_id,* url;
VImage * img;
XL_SEXP * img_ret;
int _id;
L_CHAR * refer;
XL_SEXP * p;
	obj_id = get_el(arg,1);
	switch ( get_type(obj_id) ) {
	case XLT_INTEGER:
		_id = obj_id->integer.data;
		break;
	case XLT_SYMBOL:
		refer = obj_id->symbol.data;
		goto rf;
	case XLT_STRING:
		refer = obj_id->string.data;
	rf:
		p = eval(env,n_get_symbol("__object_list"));
		if ( get_type(p) == XLT_ERROR )
			return p;
		p = vobj_get_object_by_name(p,refer,arg);
		if ( get_type(p) == XLT_ERROR )
			return p;
		if ( get_type(p) != XLT_INTEGER )
			er_panic("vobj_VxlLoadingVDraw");
		_id = obj_id->integer.data;
		break;
	case XLT_PAIR:
		obj_id = car(obj_id);
		if ( get_type(obj_id) != XLT_PAIR )
			goto err;
		obj_id = get_el(obj_id,1);
		_id = obj_id->integer.data;
		break;
	default:
	err:
		return vobj_get_error(initial_VExError(V_ER_PARAM,0,0),arg,"object ID");
	}
	obj = dynamic_cast<VDraw*>(VObject::get_object_by_id(_id));
	if ( obj == 0 )
		return vobj_get_error(initial_VExError(V_ER_NOT_FOUND,0,0),arg,0);
	url = get_el(arg,2);
	if ( get_type(url) != XLT_STRING )
		return vobj_get_error(initial_VExError(V_ER_PARAM,0,0),arg,"URL");
	img = get_image_from_sf(&img_ret,env,arg->h.file->name,sf);
	if ( img == 0 ) {
		return vobj_get_error(initial_VExError(V_ER_PARAM,0,0),arg,"errfile image");
	}
	vdraw_get_ri(img,obj,url->string.data);
	v_image_unref(img);
	return 0;
}


} // extern "C"
