/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

char ** GetListbaseEnvv;
int GetListbaseEnvc,v_offset;
XL_SEXP * xl_GetListbaseEnv();


void
init_GetListbaseEnv(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetListbaseEnv"),
		get_func_prim(xl_GetListbaseEnv,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_GetListbaseEnv(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * t;
	t = get_el(s,1);
	if ( get_type(t) != XLT_ENV )
		goto type_missmatch;
	t = get_listbase_env(t->env.data);
	if ( t == 0 )
		er_panic("xl_GetListbaseEnv");
	return t;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetListbaseEnv"),
		0);
}


