/**********************************************************************
 
	Copyright (C) 2004 
		Hirohisa MORI <joshua@nichibun.ac.jp>
		Tomohito Nakajime <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_UTime();

void
init_UTime(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"UTime"),
		get_func_prim(xl_UTime, FO_APPLICATIVE, 0, 2, 2));
}

XL_SEXP *
xl_UTime(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * file;
char *path;
int ret;
	file = get_el(s,1);
	if(get_type(file) != XLT_STRING){
		goto type_missmatch;
	}
	path = n_string(std_cm, file->string.data);
	path = change_delim_str(path);
	ret = m_utime(path, NULL);
	d_f_ree(path);
	return get_integer(ret, 0);

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"UTime"),
		List(n_get_string("filename"),
			n_get_string("is type missmatch"),
			-1));
}

