/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"xllock.h"

XL_SEXP * xl_Lock();


void
init_Lock(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Lock"),
		get_func_prim(xl_Lock,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Lock(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a_env,XL_SYM_FIELD * sf)
{
XL_SEXP * name;
int type;
L_CHAR * __file;
int __line;
int __data;
int __seq;
	name = get_el(s,1);
	if ( get_type(name) != XLT_STRING )
		goto type_missmatch;
	type = LT_READ;
	__file = 0;
	__line = 0;
	__seq = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"type")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"read")) == 0 )
				type = LT_READ;
			else if ( l_strcmp(sf->data,l_string(std_cm,"write"))
					== 0 )
				type = LT_WRITE;
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"file")) 
					== 0 ) {
			__file = sf->data;
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"line"))
					== 0 ) {
			sscanf(n_string(std_cm,sf->data),
				"%i",&__line);
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"data"))
					== 0 ) {
			sscanf(n_string(std_cm,sf->data),
				"%i",&__data);
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"seq"))
					== 0 ) {
			sscanf(n_string(std_cm,sf->data),
				"%i",&__seq);
		}
	}
	return xl_lock(name->string.data,type,s,__file,__line,__data,__seq);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Lock"),
		0);
}


