/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<sys/wait.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<signal.h>
#include	"init.h"

int sig_empty_handler_cnt;
int (*int_handler)();
int (*int_handler_glue)();

void
sig_empty_handler()
{
  sig_empty_handler_cnt ++;
}


void
all_signal_mask(int from,int to)
{
struct sigaction sa;
int sig;
	for ( sig = from ; sig <= to ; sig ++ ) {
		switch ( sig ) {
//		case SIGILL:
		case SIGKILL:
		case SIGBUS:
		case SIGSEGV:
//		case SIGSYS:
		case SIGTERM:
//		case SIGUSR1:
//		case SIGALRM:
			continue;
		}
/*
		if ( sig == 9 || sig == 10 )
			continue;
*/
		sa.sa_handler = sig_empty_handler;
		sigemptyset(&sa.sa_mask);
		sa.sa_flags = 0;
		sigaction(sig,&sa,0);
	}
}



#ifdef SIGLWP

int siglwp_handler_cnt;

void
siglwp_handler()
{
	signal(SIGLWP,siglwp_handler);
	siglwp_handler_cnt ++;
}
#endif


int sigalarm_handler_cnt;

void
sigalarm_handler()
{
	signal(SIGALRM,sigalarm_handler);
	sigalarm_handler_cnt ++;
}

int sigpipe_handler_cnt;

void
sigpipe_handler()
{
	signal(SIGPIPE,sigpipe_handler);
	sigpipe_handler_cnt++;
}

void sigint_handler()
{
	signal(SIGINT,sigint_handler);
	if ( int_handler_glue ) {
		if ( (*int_handler_glue)() < 0 )
			goto end;
		return;
	}
end:
	printf("Interrupted %i\n",(int)getpid());
	exit(1);
}



void sigchild_handler()
{
	signal(SIGCHLD,sigchild_handler);
}

int task_flags;
