/**********************************************************************
 
	Copyright (C) 2008 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"win_flame.h"


#include	"machine/u_math.h"
#include	"win_flame.h"
#include	"memory_debug.h"
#include	"gbgraph.h"

#define PRI_OFFSET_RATE		20

void _wakeup_win_manage(void *);
void wakeup_win_manage(void *);

int
e1d_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,
	 void * _ix)
{
int top,bottom;
int dy;
	dy = to.y - from.y;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( dy > 0 )
		bottom += dy;
	else	top += dy;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;
	return e2d_move(gf,wf,from,to,_ix);
}

void
copy_pixels_e1d(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,unsigned long * buf,REAL1 * reso,GB_RECT * r)
{
int x,y,i,index;
unsigned long * dest;
int f;
int bf_i;

	if ( wf->mov_flag )
		return;
	r->tl.y += wf->mov_y;
	r->tl.x += wf->mov_x;
	r->br.y += wf->mov_y;
	r->br.x += wf->mov_x;
	insert_redraw_gbr(gf,r);
	f = 0;
	bf_i = 0;
	for ( y = r->tl.y ; y < r->br.y ; y ++ ) {
		i = 0;
		for ( x = r->tl.x ; x < r->br.x ; x ++ ) {
			if ( x < 0 || x >= gf->win_width ) {
				i ++;
				bf_i ++;
				continue;
			}
			if ( y < 0 || y >= gf->win_height ) {
				i ++;
				bf_i ++;
				continue;
			}
			if ( reso[i] < 0 ) {
				i ++;
				bf_i ++;
				continue;
			}
			index = x + y*gf->win_width;
			dest = &wf->pixels[index];
			*dest = buf[bf_i]|(*dest&C_DIRTY);
			gf->redraw[index] |= RP_REDRAW;
			i ++;
			f = 1;
			bf_i ++;
		}
	}
	if ( f ) {
		new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	}
}

WF_PARAM_1D *
wf_get_param_1d(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
WF_PARAM_1D * ret;
	ret = d_alloc(sizeof(*ret));
	wf_checkout_work_area_set(wf->wa_set);
	ret->aset = wf->wa_set;
	
	ret->y_bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	ret->y_top = gf->flame_base_y_offset + wf->e1d_y_top - wf->e1d_top_mergin;
	ret->width = gf->win_width;
	return ret;
}

void
wf_free_param_1d(WF_PARAM_1D * p1d)
{
	wf_checkin_work_area_set(p1d->aset);
	d_f_ree(p1d);
}

int
e1d_redraw_rect(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,GB_RECT *r,int * pri_cnt)
{
int min_x,max_x;
int min_y,max_y;
int xx,yy,i;
unsigned long * buf;
GB_POINT * pt_list;
REAL1 * pt_reso;
int w,h;
MAP_HISTORY * mh;
WIN_FLAME * _wf;
SURP_SET surp;
int id;
int ci_ret;
GB_RECT _r;
WF_PARAM_1D * p1d;

	ci_ret = 0;
	if ( r->tl.x < 0 ) {
		if ( r->br.x <= 0 )
			return -1;
		r->tl.x = 0;
	}
	if ( r->tl.x >= gf->win_width )
		return -1;
	if ( r->br.x <= 0 )
		return -1;
	if ( r->br.x > gf->win_width ) {
		if ( r->tl.x >= gf->win_width )
			return -1;
		r->br.x = gf->win_width;
	}
	if ( r->tl.y < 0 ) {
		if ( r->br.y <= 0 )
			return -1;
		r->tl.y = 0;
	}
	if ( r->tl.y >= gf->win_height )
		return -1;
	if ( r->br.y <= 0 )
		return -1;
	if ( r->br.y > gf->win_height ) {
		if ( r->tl.y >= gf->win_height )
			return -1;
		r->br.y = gf->win_height;
	}
	min_x = r->br.x;
	min_y = r->br.y;
	max_x = r->tl.x;
	max_y = r->tl.y;


	wf_lock(gf);


	if ( wf->flags & WFF_RESIZE ) {
		wf_unlock(gf);
		return -2;
	}
	for ( xx = r->tl.x ; xx < r->br.x ; xx ++ )
		for ( yy = r->tl.y ; yy < r->br.y ; yy ++ ) {
			if ( !(wf->pixels[yy*gf->win_width + xx]&C_DIRTY) )
				continue;
			if ( min_x > xx )
				min_x = xx;
			if ( min_y > yy )
				min_y = yy;
			if ( max_x < xx+1 )
				max_x = xx+1;
			if ( max_y < yy+1 )
				max_y = yy+1;
		}
	if ( max_x < min_x ) {
		wf_unlock(gf);
		return -1;
	}
	r->tl.x = min_x;
	r->tl.y = min_y;
	r->br.x = max_x;
	r->br.y = max_y;
	wf->mov_x = 0;
	wf->mov_y = 0;
	wf->mov_flag = 0;

	w = r->br.x - r->tl.x;
	h = r->br.y - r->tl.y;
	pt_list = d_alloc(w*sizeof(GB_POINT));
	pt_reso = d_alloc(w*sizeof(REAL1));
	buf = d_alloc(w*h*sizeof(long));
	i = 0;
	for ( xx = r->tl.x ; xx < r->br.x ; xx ++ ) {
		pt_list[i].x = xx;
		pt_list[i].y = 0;
		pt_reso[i] = gf->flame_base_resolution;
		i ++;	
	}
	for ( i = 0 ; i < w*h ; i ++ )
		buf[i] = C_TRANSPARENT;
	for ( yy = r->tl.y ; yy < r->br.y ; yy ++ ) {
		for ( xx = r->tl.x ; xx < r->br.x ; xx ++ )
			wf->pixels[yy*gf->win_width + xx] &= ~C_DIRTY;
	}


	mh = add_mh(&gf->flame_base_display_map,wf->mh);


	if ( wf->flags & WFF_LUSTER )
		map_from_flame(mh,pt_list,pt_reso,w);

	_r = *r;
	_r.tl.y = _r.br.y = 0;
	set_surp(&surp,&_r,gf->flame_base_resolution);
	map_from_flame(mh,surp.ptr,surp.reso,SURP_NOS);
	id = wf->id;
	
	p1d = wf_get_param_1d(gf,wf);
	wf_unlock(gf);

	ci_ret = cache_image(
		gf,
		wf->id,wf->draw,pt_list,pt_reso,buf,
		w,r,mh,&surp,1,
		WFF_PLOT_DIRTY|WFF_LUSTER_DIRTY,
		(void*)p1d);

	wf_lock(gf);
	wf_free_param_1d(p1d);
	_wf = _get_wf_ptr(gf,id);
	if ( _wf != wf )
		goto end;
	if ( wf->flags & (WFF_FREE|WFF_FREE_OUTLIST) )
{ss_printf("FREE=RETURN-1\n");
		goto end;
}

	if ( !(ci_ret & WFF_DRAW) )
		(*pri_cnt) ++;

	if ( wf->flags & WFF_RESIZE ) {
		d_f_ree(buf);
		d_f_ree(pt_list);
		d_f_ree(pt_reso);
		free_mh(mh);
		wf_unlock(gf);
		return -2;
	}
	copy_pixels_e1d(gf,wf,buf,pt_reso,r);
	if ( wf->mov_flag )
		wf_free_si(wf);
	else	regulate_si(wf);

end:
	wf_unlock(gf);
	d_f_ree(buf);
	d_f_ree(pt_list);
	d_f_ree(pt_reso);
	free_mh(mh);
	if ( ci_ret & WFF_FLUSH )
		return -4;
	return 0;
}



extern int spiral_count;

typedef struct redraw_pixel {
	int		w;
	int		h;
	int		st_w;
	int		st_h;
	int		rdm;
	int		delta[4];
} REDRAW_PIXEL;

void set_redraw_pixel(REDRAW_PIXEL*rp,GBVIEW_FLAME * gf);


int
_e1d_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int xx,yy;
GB_RECT rr;
int t,l,r,b;
int ret;
int sc;
int pri_cnt;
REDRAW_PIXEL rp;
int wf_flush;

restart:
	wf_flush = 0;
	wf_lock(gf);
	sc = 0;
	wf->flags &= ~WFF_RESIZE;
	set_redraw_pixel(&rp,gf);
	wf_unlock(gf);
	xx = yy = 0;
	t = l = r = b = 0;
	ret = 0;
	pri_cnt = 0;
	for ( ; ; ) {
		if ( rp.st_h + yy*rp.h < 0 )
			t = 1;
		if ( rp.st_h + yy*rp.h >= gf->win_height )
			b = 1;
		if ( rp.st_w + xx*rp.w < 0 )
			l = 1;
		if ( rp.st_w + xx*rp.w >= gf->win_width )
			r = 1;
		rr.tl.x = rp.st_w + xx*rp.w;
		rr.tl.y = rp.st_h + yy*rp.h;
		rr.br.x = rr.tl.x + rp.w;
		rr.br.y = rr.tl.y + rp.h;
/*
ss_printf("** %i(%ls) ** yy %i %i %i %i %i %i\n",get_tid(),get_url_str2(&wf->draw->h.entry),
xx,yy,t,b,l,r);
*/
		switch ( e1d_redraw_rect(gf,wf,&rr,&pri_cnt) ) {
		case 0:

			ret = 1;
		case -1:
			break;
		case -2:
			goto restart;
		case -3:
			ret = 2;
			goto end;
		case -4:
			wf_flush = 1;
			break;
		default:
			er_panic("aaa");
		}
		if ( wf->flags & WFF_FREE ) {
			ret = 0;
			goto end;
		}
		if ( inc_xy(&xx,&yy) ) {
			if ( t && b && l && r )
				break;
		}
		sc ++;
//		_wf_set_delay_redraw_exec(gf);
	}
	spiral_count = sc;
end:
	if ( spiral_count )
		_set_pri_adj(gf,wf,pri_cnt*PRI_OFFSET_RATE/spiral_count);
	else	_set_pri_adj(gf,wf,pri_cnt);
	if ( wf_flush ) {
	GB_RECT rct;
		wf_work_area_flush(wf->wa_set);
		rct.tl.x = 0;
		rct.br.x = gf->win_width;
		rct.tl.y = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
		rct.br.y = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
		win_flame_dirty(gf,wf->id,&rct,WFF_LUSTER_DIRTY,0);

		goto restart;
	}

	return ret;
}

int
e1d_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
int flags;
int top,bottom;
	ret = 0;
	wf_lock(gf);
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height ) {
		wf_unlock(gf);
		return 0;
	}
	if ( bottom <= 0 ) {
		wf_unlock(gf);
		return 0;
	}

	set_weight(gf,wf);
	flags = wf->flags;

	if ( wf->flags & (WFF_POLY_DIRTY|WFF_LUSTER_DIRTY) ) {
		wf->flags &= ~(WFF_POLY_DIRTY|WFF_LUSTER_DIRTY);
		wf_unlock(gf);
		if ( _e1d_redraw(gf,wf) == 2 ) {
			ret = 2;
			wf->flags |= flags &
				(WFF_POLY_DIRTY|WFF_LUSTER_DIRTY);
		}
		else	ret = 1;
	}
	else	wf_unlock(gf);
	wf_lock(gf);
	if ( wf->flags & WFF_PLOT_DIRTY ) {
		wf->flags &= ~(WFF_PLOT_DIRTY|WFF_RESIZE);
		wf_unlock(gf);
		if ( _e1d_p_redraw(gf,wf) == 2 ) {
			ret = 2;
			wf->flags |= flags &
				(WFF_PLOT_DIRTY|WFF_RESIZE);
		}
		else	ret = 1;
	}
	else	wf_unlock(gf);
	return ret;
}



void
wf_im_zoom_proc_e1(
	unsigned long *target,
	int w,int h,
	int *index_x)
{
unsigned long *buf;
int x,y,xx,i;
	buf = d_alloc(sizeof(long)*w*h);
	i = 0;
	for ( y = 0 ; y < h ; y ++ )
		for ( x = 0 ; x < w ; x ++ ) {
			xx = index_x[x];
			if ( xx < 0 )
				buf[i] = C_TRANSPARENT;
			else	buf[i] = target[xx + y*w];
			buf[i] |= C_DIRTY;
			i ++;
		}
	for ( i = 0 ; i < h*w ; i ++ )
		target[i] = buf[i];
	d_f_ree(buf);
}

int
e1d_zoom(GBVIEW_FLAME * gf,WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y)
{
int i;
int top,bottom;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;

	wf_free_si(wf);
	wf_im_zoom_proc_e1(wf->pixels,w,h,ix_x);
	for ( i = 0 ; i < gf->win_height*gf->win_width ; i ++ )
		wf->pixels[i] |= C_DIRTY;
	e2d_zoom_wa(wf->wa_set);
	wf->flags |= WFF_DIRTY;
	return 0;
}



void
e1d_calc_pitch(GBVIEW_FLAME * gf,int flag)
{
GB_POINT pp;
REAL1 reso;

/*
	frame to resource :: reverse
*/


	pp.x = ((REAL1)gf->win_width)/2;
	pp.y = 0;
	reso = 1;
	if ( flag == 0 ) {
		map_from_flame(
			&gf->flame_base_display_map,
			&pp,
			&reso,
			1);
		pp.y = 0;
		gf->flame_base_center = pp;
	}
       	gf->flame_base_display_map.d.ln.reverse.org.x =
		-gf->win_width/(2*gf->flame_base_resolution)
		+ gf->flame_base_center.x;
/*
	gf->flame_base_display_map.d.ln.reverse.org.y =
		-gf->win_height/(2*gf->flame_base_resolution);
*/
	gf->flame_base_display_map.d.ln.reverse.org.y = 0;


	gf->flame_base_display_map.d.ln.reverse.matrix[0][0] =
		1/gf->flame_base_resolution;
	gf->flame_base_display_map.d.ln.reverse.matrix[0][1] = 0;
	gf->flame_base_display_map.d.ln.reverse.matrix[1][0] = 0;
/*
	gf->flame_base_display_map.d.ln.reverse.matrix[1][1] =
		1/gf->flame_base_resolution;
*/
	gf->flame_base_display_map.d.ln.reverse.matrix[1][1] = 0;

	gf->flame_base_display_map.d.ln.forward.org.x =
		((REAL1)gf->win_width)/2 -
		gf->flame_base_center.x*gf->flame_base_resolution;
/*
	gf->flame_base_display_map.d.ln.forward.org.y =
		((REAL1)gf->win_height)/2;
*/
	gf->flame_base_display_map.d.ln.forward.org.y = 0;

	gf->flame_base_display_map.d.ln.forward.matrix[0][0] =
		gf->flame_base_resolution;
	gf->flame_base_display_map.d.ln.forward.matrix[0][1] = 0;
	gf->flame_base_display_map.d.ln.forward.matrix[1][0] = 0;
/*
	gf->flame_base_display_map.d.ln.forward.matrix[1][1] =
		gf->flame_base_resolution;
*/
	gf->flame_base_display_map.d.ln.forward.matrix[1][1] = 0;

	gf->flame_base_display_map.d.ln.forward_reso_rate = 1;
	gf->flame_base_display_map.d.ln.reverse_reso_rate = 1;

	gf->flame_base_display_map.type = MHT_LINEAR;
	gf->flame_base_display_map.dir = MHD_REVERSE;
}



void
e1d_set_map_xy(GBVIEW_FLAME * gf,int dx)
{
MAP_HISTORY * mh;
GB_POINT ptr;
REAL1 reso;
	mh = &gf->flame_base_display_map;
	mh->d.ln.forward.org.x += dx;

	ptr.x = -dx;
	ptr.y = 0;
	mh->d.ln.reverse.org
		= p_add(mh->d.ln.reverse.org,
			mp_mul(mh->d.ln.reverse.matrix,ptr));
	mh->d.ln.reverse.org.y = 0;

	ptr.x = gf->win_width/2;
	ptr.y = gf->win_height/2;
	reso = 1;

	map_from_flame(&gf->flame_base_display_map,&ptr,&reso,1);

	gf->flame_base_center = ptr;
	gf->flame_base_center.y = 0;
}

int
e1d_move_xy(GBVIEW_FLAME * gf,VPOINT from,VPOINT to)
{
WIN_FLAME * wf;
SELECT_INDICATE * si;
int dx,dy;

	dx = to.x - from.x;
	dy = to.y - from.y;

	gf->flame_base_y_offset += dy;
	e1d_set_map_xy(gf,dx);

	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		win_flame_move(gf,wf,from,to,0);
	}
	for ( si = gf->si ; si ; si = si->next ) {
		si->x += dx;
		si->y += dy;
	}
	wf_move_redraw_x(gf,dx);
	wf_move_redraw_y(gf,dy);
	assert_ls(gf,LSF_MOVE);
	gf->move_flag = 1;
	_set_move_timer(gf);
	_wakeup_win_manage(gf->radar_ptr);

	return _get_env_seq(gf);
}


int
e1d_move_gen(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from, VPOINT to,void * ix)
{
	return e1d_move_xy(gf,from,to);
}

int 
e1d_zoom_gen
	(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf,
		int			w,
		int			h,
		int *			index_x,
		int *			index_y)
{
	wf_im_zoom_proc_e1(gf->redraw_plane,w,h,index_x);
	return 0;
}

void
e1d_wf_insert_action_gen(GBVIEW_FLAME * gf,WIN_FLAME * wf,int flags,int move_base_distance,int move_distance)
{
int top,bottom;
int offset;
WIN_FLAME * wff;
int h;
int mov,mov_base;

	mov_base = 0;
	if ( flags & WFF_HIDE ) {
		top = gf->flame_base_y_offset + wf->e1d_y_top;
		bottom = gf->flame_base_y_offset + wf->e1d_y_bottom;
		if ( bottom <= 0 ) {
			/* area A */
			mov_base = bottom - top;
			gf->flame_base_y_offset += mov_base;
		}
		else if ( top < 0 ) {
			/* area B */
			gf->flame_base_y_offset += -top;
		}
	}
	else if ( wf->next ) {
		for ( wff = wf->next ; wff ; wff = wff->next ) {
			if ( wff->flags & (WFF_FREE|WFF_HIDE) )
				continue;
			break;
		}
		if ( wff ) {
			top = gf->flame_base_y_offset + wff->e1d_y_top;
			if ( top <= 0 ) {
				gf->flame_base_y_offset -= E1D_FRAME_HEIGHT;
			}
		}
	}
	offset = 0;
	for ( wff = gf->flame ; wff ; wff = wff->next ) {
		if ( wff->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		mov = offset - wff->e1d_y_top;
		if ( wff == wf ) {
			wff->e1d_y_top = offset;
			wff->e1d_y_bottom = offset + E1D_FRAME_HEIGHT;
			wff->e1d_top_mergin = 0;
			wff->e1d_bottom_mergin = 0;
		}
		else {
			h = wff->e1d_y_bottom - wff->e1d_y_top;
			wff->e1d_y_top = offset;
			wff->e1d_y_bottom = offset + h;
		}
		offset = wff->e1d_y_bottom;
		if ( wff->tbl->f_wf_insert_action == 0 )
			continue;
		(*wff->tbl->f_wf_insert_action)(gf,wff,flags,mov_base,mov);
	}
}


void
e1d_wf_insert_action(GBVIEW_FLAME * gf,WIN_FLAME * wf,int flags,int mov_base_distance,int mov_distance)
{
int total;
	total =  mov_base_distance + mov_distance;
	if ( total == 0 )
		return;
	wf_move_y(gf,wf,total,0);
	wf_move_si(gf,wf,0,total);
	if ( wf->flags & WFF_LUSTER )
		wf->flags |= WFF_LUSTER_DIRTY;
	if ( wf->flags & WFF_POLY )
		wf->flags |= WFF_POLY_DIRTY;
	if ( wf->flags & WFF_PLOT )
		wf->flags |= WFF_PLOT_DIRTY;
}



int
e1d_overlay(GBVIEW_FLAME * gf,WIN_FLAME * wf,OV_ARG * a)
{
int top,bottom;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;
	return e2d_overlay(gf,wf,a);
}


void
e1d_setup_drawrect(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT r,float rate)
{
I_RECT rct;
	rct = get_drawrect(gf,r,rate);
	if ( rct.br.x - rct.tl.x < gf->win_width/2 &&
		wf->e1d_y_bottom - wf->e1d_y_top < gf->win_height/2 ) {
		wf->flags |= WFF_TO_SMALL;
		wf->flags &= ~WFF_TO_STD;
	}
	else {
		wf->flags &= ~WFF_TO_SMALL;
		wf->flags |= WFF_TO_STD;
	}
}


int
e1d_dirty(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT * r,int flags,int mode)
{
int i;
int x,y;
I_RECT rr;
unsigned long * p;
int f;
	f = 0;
	if ( r == 0 ) {
		for ( i = 0; i < gf->win_width*gf->win_height ; i ++ )
			wf->pixels[i] |= C_DIRTY;
			f = 1;
	}
	else {
		if ( r->tl.x < 0 )
			rr.tl.x = 0;
		else if ( r->tl.x >= gf->win_width )
			return 0;
		else	rr.tl.x = r->tl.x;
		if ( r->br.x >= gf->win_width )
			rr.br.x = gf->win_width;
		else if ( r->br.x < 0 )
			return 0;
		else	rr.br.x = r->br.x;


		for ( y = 0 ; y < gf->win_height ; y ++ ) {
			p = &wf->pixels[y*gf->win_width + rr.tl.x];
			for ( x = rr.tl.x ; x < rr.br.x ; x ++ , p ++ ) {
				*p |= C_DIRTY;
				f = 1;
			}
		}
	}
/*
	wf->rd_mode = mode;
*/
	if ( f ) {
		wf->flags |= flags & WFF_DIRTY &
			wf_get_dirty_mask(wf->flags);
		_wakeup_wf(gf,wf);
	}
	return 0;
}
