/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___SERVER_H___
#define ___SERVER_H___

#include	"stream.h"
#include	"netutils.h"

typedef struct al_info_header {
	void			(*free_func)(struct al_info_header*);
} AL_INFO_HEADER;

#define HAT_ALL			200
#define HAT_ME			201
#define HAT_ERROR		202
#define HAT_XLPROX_DOMAIN	204
#define HAT_XLPROX_HOST_ENTRY	206

typedef union host_addr_ext {
	short			type;
	struct {
		HOST_ADDR		addr;
		HOST_ADDR		mask;
	} am;
	struct {
		short		type;
		short		size;
		int		port;
		char *		name;
		int		id;
	} domain;
	struct {
		short		type;
		short		size;
		int		port;
		HOST_ENTRY *	he;
		int		id;
	} he;
} HOST_ADDR_EXT;


typedef struct access_list {
	struct access_list *	next;
/*
	int			ip;
	int			mask;
	char *			domain;
	int			port;
	int			accept_id;
	int			auth_type;
#define ATH_NONE		0
#define ATH_PASSWD		1
#define ATH_KEYCODE		2
#define ATH_THIRDPERTY		3
	int			auth_flags;
*/
	HOST_ADDR_EXT		src;
	HOST_ADDR_EXT		dest;
	int			type;
#define AP_ALLOW		1
#define AP_DENY			0
	void			(*free_info)();
	AL_INFO_HEADER *	info;
} ACCESS_LIST;

typedef struct access_permission {
	ACCESS_LIST *		head;
	ACCESS_LIST *		tail;
} ACCESS_PERMISSION;

typedef struct access_key {
	STREAM *		s;
	int			ip;
	void *			work;
} ACCESS_KEY;

ACCESS_KEY * accept_connection(STREAM *);
STREAM * init_server(int * open_port,int base_port,int limit);
void close_key(ACCESS_KEY * key);
void init_access_permission(ACCESS_PERMISSION * ap);
void free_access_list(ACCESS_PERMISSION * ap);
void
insert_access_list(
	ACCESS_PERMISSION * ap,
	HOST_ADDR_EXT *		src,
	HOST_ADDR_EXT *		dest,
	int			type,
	AL_INFO_HEADER *	info);
ACCESS_LIST *
check_permission(ACCESS_PERMISSION * ap,HOST_ADDR_EXT * src,HOST_ADDR_EXT * dest);
int
get_inet_addr(HOST_ADDR_EXT * ha,char * str);
char * 
get_string_inet_addr(HOST_ADDR_EXT * );
STREAM * 
connect_stream_routing(int * cerr,HOST_ADDR_EXT * addr,int routing_flag,int ttl,int timeout_sec);
void
free_host_addr_ext(HOST_ADDR_EXT * d);
int inet_addr_xl(char*);

#define SR_TTL	10
#define SR_DEFAULT_TIMEOUT	600

#endif


