/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/include.h"
/*
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
*/
#include	"geo.h"
#include	"change_endian.h"
#include	"u_file.h"
#include	"memory_debug.h"

void
str_mid(char *dest,char *source,int num1,int num2);
void
str_right(char *dest,char *source,int num);



int load_dted1(short * data,int * org_east,int * org_north,int * line_nos_p,
		char *dir_name,char *filename,int cmd)

{
	short	dem1;
	int	sec;
	int	org_n,org_e;
	char	fnm[20];
	int	i,j;
	char 	path[127];
	short * dp,*sp;
	short * dpp, * spp, * hpp;

	int dir_name_len;

	int 	fp1;
	int	filesize;
	int	line_nos;
	
	short *	buf;

	sec= 3;


	dir_name_len = strlen(dir_name);
	if ( dir_name_len < 4 )
		return -1;

	org_e = atoi(&dir_name[dir_name_len-3])*3600;
	switch ( dir_name[dir_name_len-4] ) {
	case 'e':
	case 'E':
		break;
	case 'w':
	case 'W':
		org_e = -org_e;
		break;
	default:
		return -2;
	}

	if ( strcmp(&filename[3],".dt1")  )
		return -3;

	memcpy(fnm,filename,5);
	fnm[3] = 0;
	org_n = (atoi(&fnm[1])+1)*3600;
	switch ( fnm[0] ) {
	case 'n':
	case 'N':
		break;
	case 's':
	case 'S':
		org_n = -org_n;
		break;
	default:
		return -4;
	}

	*org_east = org_e;
	*org_north = org_n;
	if ( (cmd & DTED1_CMD_BASE) == DTED1_CMD_POS )
		return 0;

	strcpy(path,dir_name);
	strcpy(&path[dir_name_len],"/");
	strcpy(&path[dir_name_len+1],filename);

	fp1 = u_open64(path,O_RDONLY);
	if ( fp1 < 0 )
		return -5;
	filesize = u_lseek64(fp1,0,SEEK_END);
	line_nos = (filesize - 3428)/2414;

	switch ( line_nos ) {
	case DTED1_HALF_SIZE:
		break;
	case DTED1_BLOCK_SIZE:
		break;
	default:
ss_printf("LENGTH %i\n",line_nos);
		u_close(fp1);
		return -6;
	}
	
	if ( line_nos_p )
		*line_nos_p = line_nos;

	switch ( cmd & DTED1_CMD_BASE ) {
	case DTED1_CMD_DIRECT:
		dp = data;
		break;
	case DTED1_CMD_ROUND:
		dp = buf = d_alloc(sizeof(short)*DTED1_BLOCK_SIZE*DTED1_BLOCK_SIZE);
		break;
	}
	
	u_lseek64(fp1,3428,SEEK_SET);

//printf("====DATA\n");
	
	for (i=0; i<line_nos; i++) {
//		n = org_n + (sec * i);

       		u_lseek64(fp1, 8L, SEEK_CUR);
//printf("====LINE\n");

		for (j=0; j<1201; j++) {
//			e = org_e + (sec * j);

			u_read(fp1,&dem1, 2);
//printf("dem1=pref=%x\n",dem1);
			change_endian(dem1);

 			if ( dem1 < 0 ) {
				dem1 &= 0x7fff;
				dem1 = -dem1;
			}

//printf("dem1=after=%x \n",dem1);
			
			*dp++ = dem1;
		}
		u_lseek64(fp1, 4L, SEEK_CUR);
	}
	u_close( fp1 );
	
	if ( (cmd & DTED1_CMD_OPT) == DTED1_CMD_INTP && 
		line_nos == DTED1_HALF_SIZE ) {
		sp = buf + DTED1_BLOCK_SIZE*(DTED1_HALF_SIZE-1);
		dp = buf + DTED1_BLOCK_SIZE*(DTED1_BLOCK_SIZE-1);
		i = DTED1_BLOCK_SIZE;
		for ( ; i > 0 ; i -= 2 , dp -= DTED1_BLOCK_SIZE*2 
				, sp -= DTED1_BLOCK_SIZE ) {
			memcpy(dp,sp,sizeof(short)*DTED1_BLOCK_SIZE);
		}
		sp = buf;
		for ( i = 0 ; i < DTED1_HALF_SIZE-1 ; i ++ ) {
			spp = sp;
			hpp = sp + DTED1_BLOCK_SIZE;
			dp = dpp = hpp + DTED1_BLOCK_SIZE;
			for ( j = 0 ; j < DTED1_BLOCK_SIZE ; j ++ ) {
				if ( *spp == (short)0x8000 && *dpp == (short)0x8000 )
					*hpp = 0x8000;
				else if ( *spp == (short)0x8000 )
					*hpp = *dpp;
				else if ( *dpp == (short)0x8000 )
					*hpp = *spp;
				else	*hpp = (*spp + *dpp)/2;
				spp ++;
				hpp ++;
				dpp ++;
			}
			sp = dp;
		}
		line_nos = DTED1_BLOCK_SIZE;
	}
	
	if ( (cmd & DTED1_CMD_BASE) == DTED1_CMD_DIRECT )
		return 0;

	dp = data;
	sp = buf + DTED1_BLOCK_SIZE-1;
	for ( i = 0 ; i < DTED1_BLOCK_SIZE ; i ++ ) {
		spp = sp;
		for ( j = 0 ; j < line_nos ; j ++ ) {
			*dp ++ = *spp;
			spp += DTED1_BLOCK_SIZE;
		}
		sp --;
	}
	d_f_ree(buf);
	
	return 0;
}
