/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "v/v_types.h"
#include "xlerror.h"

extern XLISP_ENV *	vobj_env;
XL_SEXP * vxl_VMT_STR(XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);


void
init_vobj_function_xl_utils()
{
	set_env(vobj_env,l_string(std_cm,"VxlVMTstr"),
		get_func_prim((XL_SEXP*(*)())vxl_VMT_STR,FO_NORMAL,0,2,2));

}

void
init_vobj_function_xl()
{
	init_vobj_function();
	init_vobj_function_xl_utils();
	init_vobj_VxlText(vobj_env);
	init_vobj_VxlEditLine(vobj_env);
	init_vobj_VxlTreeView(vobj_env);
	init_vobj_VxlLoadingVDraw(vobj_env);
}


XL_SEXP * vxl_VMT_STR(XLISP_ENV * e,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
char buf[50];
XL_SEXP * d;
L_CHAR * type;
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	d = get_el(s,1);
	if ( get_type(d) != XLT_INTEGER )
			goto typemissmatch;
	if ( type == 0 )
		goto string;
	else if ( l_strcmp(type,l_string(std_cm,"string")) == 0 ) {
string:
		sprintf(buf,"#%i",(int)VMT_CONV(d->integer.data));
		return n_get_string(buf);
	}
	else if ( l_strcmp(type,l_string(std_cm,"integer")) == 0 ) {
		return get_integer(VMT_CONV((short)d->integer.data),0);
	}

	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"VxlVMTstr"),
		n_get_string("invalid type attribute"));

typemissmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"VxlVMTstr"),
		n_get_string("id type missmatch"));
}

