// ===========================================================================
//	CSplitView.h                                   2004.12.28  Tomoki Sekiyama
// ===========================================================================

#ifndef _H_CSplitView
#define _H_CSplitView
#pragma once

#include <LView.h>
#include <LStream.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

const MessageT msg_SplitBarMoved = 9001;	// param = (void*)position

class CSplitView : public LView,
				   public LBroadcaster {
public:
	enum { class_ID = FOUR_CHAR_CODE('Cspv') };
	
					CSplitView();

					CSplitView( LStream* inStream );

					CSplitView(
							const SPaneInfo&	inPaneInfo,
							const SViewInfo&	inViewInfo,
							bool				inVertical);

	virtual			~CSplitView();

	virtual void	ResizeFrameBy(
							SInt16		inWidthDelta,
							SInt16		inHeightDelta,
							Boolean		inRefresh);

	virtual void	Click( SMouseDownEvent& inMouseDown );
	
	
	virtual void	SetChild( UInt8 n, LPane* pane );
	virtual LPane*	GetChild( UInt8 n ) const
						{
							return n < 2 ? mChild[n] : NULL;
						}
	
	virtual void	SetShrinkable( Boolean sh0, Boolean sh1 )
						{
							mShrinkable[0] = sh0;
							mShrinkable[1] = sh1;
						}
	virtual void	GetShrinkable( Boolean &sh0, Boolean &sh1 ) const
						{
							sh0 = mShrinkable[0];
							sh1 = mShrinkable[1];
						}

	virtual void	SetMinMax( UInt16 min, UInt16 max );
	virtual void	GetMinMax( UInt16& min, UInt16& max ) const
						{
							min = mMin;
							max = mMax;
						}

	virtual void	SetPosition( UInt16 pos, Boolean redraw );
	virtual UInt16	GetPosition() const
						{
							return mPosition;
						}

	virtual void	ShowChild( UInt8 n );
	virtual void	HideChild( UInt8 n );

	void			(*Shrink1onResize_Callback)(
										CSplitView*	target,
										UInt16		pos,
										UInt16		rr);

protected:
	virtual void	FinishCreateSelf();

	virtual void	DrawSelf();
	virtual void	CalcSplitBarFrame( Rect &frame );

	static void		DefaultShrink1onResize(
										CSplitView*	target,
										UInt16		pos,
										UInt16		rr);

protected:
	LPane*			mChild[2];
	UInt16			mMin, mMax, mPosition;
	Boolean			mVertical;
	Boolean			mShrinkable[2];
	Boolean			mChildHidden[2];
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif