/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef _H_LMouseTracker
#define _H_LMouseTracker
#pragma once

#include <LPane.h>
#include <LPeriodical.h>


class	VMouseTracker : public LPeriodical {
public:
						VMouseTracker();
	virtual				~VMouseTracker();

	virtual void		SpendTime( const EventRecord& inMacEvent );
	
	static const EventRecord *	CurrentMacEvent() { return sCurrentEvent; }
	static bool			ButtonState() { return sButtonState; }
	static void			DontForceQuitTracking() { sNoForceQuitTracking = true; }
	
protected:
	static LPane *		CheckEnterLeave( const EventRecord& inMacEvent );

	static short		sButtonState;
	static LPane *		sTracked;
	static LPane *		sLastPointed;
	static Point		sLastPoint;
	static Point		sPortMouse;
	static bool			sNoForceQuitTracking;
	static const EventRecord *	sCurrentEvent;
};

#endif