/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<sys/wait.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<signal.h>
#include	<errno.h>
#include	"init.h"
#include	"task.h"
#include	"memory_debug.h"
#include	"utils.h"

void sigalarm_handler();
void sigpipe_handler();
void sigint_handler();
void siglwp_handler();


extern int task_flags;
int pri_table[PRI_MAX] = {0,10,20,30,40,50};

typedef struct sem_list_t {
	struct sem_list_t *	next;
	char *			file;
	unsigned int		line;
	int			cnt;
	struct sem_list_t *	max_next;
} SEM_LIST_T;

#define SLT_LEN		23
SEM_LIST_T *	slt[SLT_LEN];
SEM_LIST_T *	max_slt;
int sem_nos;

void
sem_max_check()
{
static INTEGER64 tt;
INTEGER64 ttt;
SEM_LIST_T * m;
int i;
	ttt = get_xltime();
	if ( ttt < tt + 5 )
		return;
	tt = ttt;
	max_slt = 0;
	for ( i = 0 ; i < SLT_LEN ; i ++ ) {
		for ( m = slt[i] ; m ; m = m->next ) {
			if ( max_slt == 0 || max_slt->cnt < m->cnt ) {
				m->max_next = max_slt;
				max_slt = m;
			}
		}
	}
}

SEM_LIST_T *
search_slt(char * file,unsigned int line)
{
SEM_LIST_T * ret;
unsigned int key;
	key = line % SLT_LEN;
	for ( ret = slt[key] ; ret ; ret = ret->next ) {
		if ( ret->line != line )
			continue;
		if ( strcmp(ret->file,file) )
			continue;
		return ret;
	}
	return 0;
}

void
insert_slt(char * file,unsigned int line)
{
SEM_LIST_T * s;
unsigned int key;
	s = search_slt(file,line);
	if ( s == 0 ) {
		s = malloc(sizeof(*s));
		s->file = file;
		s->line = line;
		s->cnt = 1;
		key = line % SLT_LEN;
		s->next = slt[key];
		slt[key] = s;
	}
	else {
		s->cnt ++;
	}
	sem_max_check();
}

void
delete_slt(char * file,unsigned line)
{
SEM_LIST_T * s;
	s = search_slt(file,line);
	if ( s == 0 ) {
		fprintf(stderr,"FILE %s %i\n",file,line);
		er_panic("there is no semaphore");
	}
	s->cnt --;
	if ( s->cnt < 0 )
		er_panic("????");
}


sem_t*
new_semaphore()
{
sem_t * s;
char name[16];
static int sem_num;
int i = 0;

	do {
		sprintf(name, "%d-%04i", getpid(), ++sem_num);
		s = sem_open(name, O_CREAT | O_EXCL, 0600, 0);
		i++;
	} while ( s == (sem_t*)SEM_FAILED && i < 10 );
	if ( i == 10 ) {
		perror("new_semaphore");
		printf("name : %s\n", name);
		er_panic("new_semaphore");
	}
	sem_unlink(name);
	sem_trywait(s);
	for ( ; sem_post(s); );
	return s;
}


void
_lock_task(D_SEM s,char * file,int line)
{
int er;
	switch ( er=pthread_mutex_lock(&s->mx) ) {
	case 0:
		break;
	case EINVAL:
		printf("invalid semaphore (MUTEX)\n");
		printf("%s\n",(char*)1);
	case EDEADLK:
		printf("dead lock\n");
		printf("%s\n",(char*)1);
	default:
		printf("ER = %i\n",er);
		printf("%s\n",(char*)1);
	}

	if ( s->trace_bit ) {
		s->value = 0;
		s->tid = _get_tid();
	}
	s->lock_file = file;
	s->lock_line = line;


}

void
_unlock_task(D_SEM s,char *str,char * file,int line)
{
int er;

	s->unlock_file = file;
	s->unlock_line = line;
	
	if ( s->trace_bit ) {
		s->value = 1;
		s->tid = invalid_htid();
	}

	switch ( pthread_mutex_unlock(&s->mx) ) {
	case 0:
		break;
	case EINVAL:
		er_panic("invalid semaphore (MUTEX)");
	case EPERM:
		er_panic("nlock non locked lock");
	default:
		printf("ER = %i\n",er);
		er_panic("unknown return");
	}
}

void xx_close_lock(D_SEM s)
{
sem_nos --;
	pthread_mutex_destroy(&s->mx);
	free_block(s);
}

D_SEM
xx_new_lock(int level,char * file,int line)
{
D_SEM s;
pthread_mutexattr_t attr;
	s = new_block();
	pthread_mutexattr_init(&attr);
	pthread_mutexattr_settype(&attr,PTHREAD_MUTEX_ERRORCHECK);
	pthread_mutex_init(&s->mx,&attr);
	pthread_mutexattr_destroy(&attr);
sem_nos ++;
	return s;
}

void
set_trace_bit(SEM s)
{
	s.so->d_sem->trace_bit = 1;
}

int
_sem_getvalue(D_SEM s,int * value)
{
int er;
	switch ( er=pthread_mutex_trylock(&s->mx) ) {
	case 0:
		*value = 0;
	case EINVAL:
		er_panic("invalid semaphore (MUTEX)");
	case EPERM:
		*value = 1;
		break;
	default:
		printf("ER = %i\n",er);
		er_panic("unknown return");
	}
	return 0;
}


 
int
ss_do(void (*func)(void*),void * arg)
{
	(*func)(arg);
	return 0;
}
