/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"


extern THREAD_BLOCK	tb[THREAD_BLOCK_SIZE];
extern THREAD_BLOCK *	tb_free_list;

D_SEM	block_lock;

/* Set the mutex kind attribute in *ATTR to KIND (either PTHREAD_MUTEX_NORMAL,                                  
   PTHREAD_MUTEX_RECURSIVE, PTHREAD_MUTEX_ERRORCHECK, or                                                        
   PTHREAD_MUTEX_DEFAULT).  */
extern int pthread_mutexattr_settype (pthread_mutexattr_t *__attr, int __kind)
     __THROW;

/* Return in *KIND the mutex kind attribute in *ATTR.  */
extern int pthread_mutexattr_gettype (__const pthread_mutexattr_t *__restrict
                                      __attr, int *__restrict __kind) __THROW;



void
init_thread_block()
{
int i;
D_SEM s;
pthread_mutexattr_t attr;

	s = &tb[0].sem;

	pthread_mutexattr_init(&attr);
	pthread_mutexattr_settype(&attr,PTHREAD_MUTEX_ERRORCHECK_NP);
	pthread_mutex_init(&s->mx,&attr);
	pthread_mutexattr_destroy(&attr);

	block_lock = s;
	_lock_task(block_lock,__FILE__,__LINE__);
	for ( i = 1 ; i < THREAD_BLOCK_SIZE ; i ++ ) {
		tb[i].next = tb_free_list;
		tb_free_list = &tb[i];
	}
	_unlock_task(block_lock,"init_thread_block",__FILE__,__LINE__);
}
