/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"memory_routine.h"
#include	"xl.h"

#include	"v/v_types.h"

void	gc_view_lock();
void	gc_view_unlock();
void	gc_view();
void	gc_htmldb();
void	sp_gc_lib();
void	after_gc_lib();

extern SEM style_lock,dm_lock;

void
gc_lock()
{
	gc_view_lock();
	gc_vobj_utils_lock();
	VMacro_gc_lock();
}

void
gc_unlock()
{
	gc_view_unlock();
	VMacro_gc_unlock();
	gc_vobj_utils_unlock();
}


void
gc()
{
	GC_POSITION;

	gc_view();

	GC_POSITION;

	gc_htmldb();
	gc_vobj_utils();
	VMacro_gc();
}

void
sp_gc()
{
	sp_gc_lib();
}

void
after_gc()
{
	after_gc_lib();
}

