/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"
#include	"xl.h"
#include	"xlerror.h"

int
list2vector(XL_SEXP ** ret,GB_POINT * p,XL_SEXP * v,XL_FILE * file,int line,
	char * er_func)
{
XL_SEXP * xx;
	switch ( list_length(v) ) {
	case -1:
		*ret = list_error(v);
		return -1;
	case 2:
		break;
	default:
		goto type_missmatch;
	}
	xx = get_el(v,0);
	switch ( get_type(xx) ) {
	case XLT_INTEGER:
		p->x = xx->integer.data;
		break;
	case XLT_FLOAT:
		p->x = xx->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	xx = get_el(v,1);
	switch ( get_type(xx) ) {
	case XLT_INTEGER:
		p->y = xx->integer.data;
		break;
	case XLT_FLOAT:
		p->y = xx->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	return 0;

type_missmatch:
	*ret = get_error(
		file,
		line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,er_func),
		list(n_get_string("type missmatch"),0));
	return -1;
}

int
list2matrix(XL_SEXP ** ret,REAL1 mret[2][2],XL_SEXP * m,
		XL_FILE * file,int line,char * er_func)
{
GB_POINT p;
	switch ( list_length(m) ) {
	case -1:
		*ret = list_error(m);
		return -1;
	case 2:
		break;
	default:
		goto type_missmatch;
	}
	if ( list2vector(ret,&p,get_el(m,0),file,line,er_func) < 0 )
		return -1;
	mret[0][0] = p.x;
	mret[0][1] = p.y;
	if ( list2vector(ret,&p,get_el(m,1),file,line,er_func) < 0 )
		return -1;
	mret[1][0] = p.x;
	mret[1][1] = p.y;
	return 0;
type_missmatch:
	*ret = get_error(
		file,
		line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,er_func),
		list(n_get_string("type missmatch"),0));
	return -1;
}

