/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"ppm_types.h"


XL_SEXP * gb_gmxStatus_n();

XL_SEXP * gb_gmxStatus_s();


void
init_gmxStatus(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env0,l_string(std_cm,"gmxStatus"),
		get_func_prim(gb_gmxStatus_n,FO_APPLICATIVE,0,1,2));
	set_env(env1,l_string(std_cm,"gmxStatus"),
		get_func_prim(gb_gmxStatus_s,FO_APPLICATIVE,0,1,2));
}


XL_SEXP *
_get_mx_status(int s_flag,MX_ENTRY * e)
{
MATRIX * m;
XL_SEXP * ret;
XL_SEXP * sym;
XL_SEXP * sym2,* sym3;
XL_SEXP * target;
char buf[30];
int i;
MATRIX_CHANNEL_INFO * info;
XL_SEXP * mode_phase[MI_MAX];
int mode_pri[MI_MAX];
	m = e->c.m;

check_mx_entry(e);
	sym = n_get_symbol("gmxStatus");
	ret = 0;
	if ( m->neturl )
		set_attribute(sym,l_string(std_cm,"neturl"),m->neturl);
	if ( m->filename )
		set_attribute(sym,l_string(std_cm,"filename"),m->filename);
	if ( m->key )
		set_attribute(sym,l_string(std_cm,"key"),m->key);
	if ( s_flag ) {
check_mx_entry(e);
		if ( load_mode_cal(mode_phase,0,m,MI_MODE_CLIENT) < 0 ) {
			sym2 = n_get_symbol("gmxPhase");
			set_attribute(sym2,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"client"));
			ret = cons(cons(sym2,0),ret);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( get_type(mode_phase[i]) == XLT_NULL )
					continue;
				sym2 = n_get_symbol("gmxPhase");
				sprintf(buf,"%i",i);
				set_attribute(sym2,l_string(std_cm,"area"),l_string(std_cm,buf));
				set_attribute(sym2,l_string(std_cm,"mode"),l_string(std_cm,"client"));
				ret = cons(cons(sym2,mode_phase[i]),ret);
			}
		}
		if ( load_mode_cal(mode_phase,0,m,MI_MODE_SERVER) < 0 ) {
			sym2 = n_get_symbol("gmxPhase");
			set_attribute(sym2,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"server"));
			ret = cons(cons(sym2,0),ret);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( get_type(mode_phase[i]) == XLT_NULL )
					continue;
				sym2 = n_get_symbol("gmxPhase");
				sprintf(buf,"%i",i);
				set_attribute(sym2,l_string(std_cm,"area"),l_string(std_cm,buf));
				set_attribute(sym2,l_string(std_cm,"mode"),l_string(std_cm,"server"));
				ret = cons(cons(sym2,mode_phase[i]),ret);
			}
		}
check_mx_entry(e);
		if ( load_mode_cal(mode_phase,0,m,MI_MODE_DIRECT) < 0 ) {
			sym2 = n_get_symbol("gmxPhase");
			set_attribute(sym2,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"direct"));
			ret = cons(cons(sym2,0),ret);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( get_type(mode_phase[i]) == XLT_NULL )
					continue;
				sym2 = n_get_symbol("gmxPhase");
				sprintf(buf,"%i",i);
				set_attribute(sym2,l_string(std_cm,"area"),l_string(std_cm,buf));
				set_attribute(sym2,l_string(std_cm,"mode"),l_string(std_cm,"direct"));
				ret = cons(cons(sym2,mode_phase[i]),ret);
			}
		}
		for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
			if ( m->cal[i] == 0 )
				continue;
			if ( get_type(m->cal[i]->data) == XLT_NULL )
				continue;
			sym2 = n_get_symbol("gmxPhase");
			sprintf(buf,"%i",i);
			set_attribute(sym2,l_string(std_cm,"area"),l_string(std_cm,buf));
			ret = cons(cons(sym2,m->cal[i]->data),ret);
		}
	}
	else {
check_mx_entry(e);
		if ( load_mode_cal(mode_phase,0,m,MI_MODE_CLIENT) < 0 ) {
			sym2 = n_get_symbol("gmxPhase");
			set_attribute(sym2,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			ret = cons(cons(sym2,0),ret);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( get_type(mode_phase[i]) == XLT_NULL )
					continue;
				sym2 = n_get_symbol("gmxPhase");
				sprintf(buf,"%i",i);
				set_attribute(sym2,l_string(std_cm,"area"),l_string(std_cm,buf));
				ret = cons(cons(sym2,mode_phase[i]),ret);
			}
		}
	}
check_mx_entry(e);
	for ( i = m->p.dim-1 ; i >=0 ; i -- ) {
		sym2 = n_get_symbol("gmxMatrixPixelSize");
		sprintf(buf,I64_FORMAT,m->pixel_size[i]);
		set_attribute(sym2,l_string(std_cm,"value"),l_string(std_cm,buf));
		sprintf(buf,"%i",i);
		set_attribute(sym2,l_string(std_cm,"dim"),l_string(std_cm,buf));
		ret = cons(List(sym2,-1),ret);
	}
	for ( i = m->p.dim-1 ; i >=0 ; i -- ) {
		sym2 = n_get_symbol("gmxMatrixBlockSize");
		sprintf(buf,"%i",m->block_size[i]);
		set_attribute(sym2,l_string(std_cm,"value"),l_string(std_cm,buf));
		sprintf(buf,"%i",i);
		set_attribute(sym2,l_string(std_cm,"dim"),l_string(std_cm,buf));
		ret = cons(List(sym2,-1),ret);
	}
	for ( i = m->p.dim-1 ; i >=0 ; i -- ) {
		sym2 = n_get_symbol("gmxMatrixDimDivide");
		sprintf(buf,"%i",m->dim_divide[i]);
		set_attribute(sym2,l_string(std_cm,"value"),l_string(std_cm,buf));
		sprintf(buf,"%i",i);
		set_attribute(sym2,l_string(std_cm,"dim"),l_string(std_cm,buf));
		ret = cons(List(sym2,-1),ret);
	}
	sprintf(buf,"%i",m->total_levels);
	set_attribute(sym,l_string(std_cm,"total_levels"),l_string(std_cm,buf));
check_mx_entry(e);
	
	for ( i = m->p.channel_nos-1 ; i >= 0 ; i -- ) {
		info = &m->channel_info[i];
		if ( info->data_type == 0 )
			continue;
		if ( s_flag ) {
			sym2 = n_get_symbol("gmxChannelInfo");
			if ( info->flags & MF_SEND_FILE )
				set_attribute(sym2,l_string(std_cm,"send_file"),l_string(std_cm,"on"));
			if ( info->flags & MF_SEND_VISU )
				set_attribute(sym2,l_string(std_cm,"send_visu"),l_string(std_cm,"on"));
			if ( info->flags & MF_SEND )
				set_attribute(sym2,l_string(std_cm,"send"),l_string(std_cm,"on"));
			if ( info->flags & MF_FILE )
				set_attribute(sym2,l_string(std_cm,"file"),l_string(std_cm,"on"));
			if ( info->flags & MF_VISU )
				set_attribute(sym2,l_string(std_cm,"visu"),l_string(std_cm,"on"));
		}
		else {
			sym2 = n_get_symbol("gmxChannelInfo");
			if ( info->flags & MF_SEND_FILE )
				set_attribute(sym2,l_string(std_cm,"file"),l_string(std_cm,"on"));
			if ( info->flags & MF_SEND_VISU )
				set_attribute(sym2,l_string(std_cm,"visu"),l_string(std_cm,"on"));
		}
		set_attribute(sym2,l_string(std_cm,"type"),l_string(std_cm,info->data_type->type_name));
		sprintf(buf,"%i",i);
		set_attribute(sym2,l_string(std_cm,"channel"),l_string(std_cm,buf));
		if ( info->default_data ) {
			if ( info->data_type->parent )
				ret = cons(List(sym2,(*info->data_type->parent->md2sexp)
						(info->data_type->parent,info->default_data),-1),ret);
			else 
				ret = cons(List(sym2,(*info->data_type->md2sexp)
						(info->data_type,info->default_data),-1),ret);
		}
		else {
			ret = cons(List(sym2,-1),ret);
		}
	}
	
check_mx_entry(e);
	sym2 = n_get_symbol("gmxMatrixParam");
	sprintf(buf,I64_FORMAT,m->p.modify_time);
	set_attribute(sym2,l_string(std_cm,"modify_time"),l_string(std_cm,buf));
	sprintf(buf,"%i",m->p.total_levels);
	set_attribute(sym2,l_string(std_cm,"total_levels"),l_string(std_cm,buf));
	if ( m->p.flags & MPF_INDEX_HEM ) 
		set_attribute(sym2,l_string(std_cm,"index_hem"),l_string(std_cm,"on"));
	if ( m->p.flags & MPF_CACHE_FILE ) 
		set_attribute(sym2,l_string(std_cm,"cache_file"),l_string(std_cm,"on"));
	sprintf(buf,"%i",m->p.dim);
	set_attribute(sym2,l_string(std_cm,"dim"),l_string(std_cm,buf));
	sprintf(buf,"%i",m->p.channel_nos);
	set_attribute(sym2,l_string(std_cm,"channel_nos"),l_string(std_cm,buf));
	
	if ( s_flag ) {
check_mx_entry(e);
		target = 0;
		if ( load_mode_cal(0,mode_pri,m,MI_MODE_DIRECT) < 0 ) {
			sym3 = n_get_symbol("gmxPriority");
			set_attribute(sym3,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"direct"));
			target = cons(cons(sym3,0),target);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( mode_pri[i] == 0 )
					continue;
				sym3 = n_get_symbol("gmxPriority");
				sprintf(buf,"0x%x",m->p.pri_area[i]);
				set_attribute(sym3,l_string(std_cm,"pri"),l_string(std_cm,buf));
				sprintf(buf,"%i",i);
				set_attribute(sym3,l_string(std_cm,"area"),l_string(std_cm,buf));
				set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"direct"));
				target = cons(List(sym3,-1),target);
			}
		}
		if ( load_mode_cal(0,mode_pri,m,MI_MODE_SERVER) < 0 ) {
			sym3 = n_get_symbol("gmxPriority");
			set_attribute(sym3,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"server"));
			target = cons(cons(sym3,0),target);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( mode_pri[i] == 0 )
					continue;
				sym3 = n_get_symbol("gmxPriority");
				sprintf(buf,"0x%x",m->p.pri_area[i]);
				set_attribute(sym3,l_string(std_cm,"pri"),l_string(std_cm,buf));
				sprintf(buf,"%i",i);
				set_attribute(sym3,l_string(std_cm,"area"),l_string(std_cm,buf));
				set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"server"));
				target = cons(List(sym3,-1),target);
			}
		}
check_mx_entry(e);
		if ( load_mode_cal(0,mode_pri,m,MI_MODE_CLIENT) < 0 ) {
			sym3 = n_get_symbol("gmxPriority");
			set_attribute(sym3,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"client"));
			target = cons(cons(sym3,0),target);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( mode_pri[i] == 0 )
					continue;
				sym3 = n_get_symbol("gmxPriority");
				sprintf(buf,"0x%x",m->p.pri_area[i]);
				set_attribute(sym3,l_string(std_cm,"pri"),l_string(std_cm,buf));
				sprintf(buf,"%i",i);
				set_attribute(sym3,l_string(std_cm,"area"),l_string(std_cm,buf));
				set_attribute(sym3,l_string(std_cm,"mode"),l_string(std_cm,"client"));
				target = cons(List(sym3,-1),target);
			}
		}
		for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
			if ( m->p.pri_area[i] == 0 )
				continue;
			sym3 = n_get_symbol("gmxPriority");
			sprintf(buf,"0x%x",m->p.pri_area[i]);
			set_attribute(sym3,l_string(std_cm,"pri"),l_string(std_cm,buf));
			sprintf(buf,"%i",i);
			set_attribute(sym3,l_string(std_cm,"area"),l_string(std_cm,buf));
			target = cons(List(sym3,-1),target);
		}
		ret = cons(cons(sym2,target),ret);
	}
	else {
check_mx_entry(e);
		target = 0;
		if ( load_mode_cal(0,mode_pri,m,MI_MODE_CLIENT) < 0 ) {
			sym3 = n_get_symbol("gmxPriority");
			set_attribute(sym3,l_string(std_cm,"error"),l_string(std_cm,"cannot access the mode record"));
			target = cons(cons(sym3,0),target);
		}
		else {
			for ( i = MI_MAX-1 ; i >= 0 ; i -- ) {
				if ( mode_pri[i] == 0 )
					continue;
				sym3 = n_get_symbol("gmxPriority");
				sprintf(buf,"0x%x",m->p.pri_area[i]);
				set_attribute(sym3,l_string(std_cm,"pri"),l_string(std_cm,buf));
				sprintf(buf,"%i",i);
				set_attribute(sym3,l_string(std_cm,"area"),l_string(std_cm,buf));
				target = cons(List(sym3,-1),target);
			}
		}
		ret = cons(cons(sym2,target),ret);
	}
check_mx_entry(e);
	return cons(sym,ret);
}



XL_SEXP *
get_mx_status(int s_flag,MX_ENTRY * e)
{
XL_SEXP * sts;
XL_SEXP * x;
int i;
MATRIX * m;
	m = e->c.m;
	sts = 0;
	for ( i = m->p.dim-1 ; i >= 0 ; i -- ) {
		x = get_integer(m->pixel_size[i],l_string(std_cm,"dot"));
		sts = cons(x,sts);
	}
	sts = cons(get_integer(m->total_levels,0),sts);
	return List(n_get_symbol("status"),
		List(n_get_symbol("general"),
			cons(n_get_symbol("dim"),sts),
			-1),
		_get_mx_status(s_flag,e),
		-1);
}

XL_SEXP *
open_status_related(int s_flag,L_CHAR * file,XL_SEXP * s)
{
L_CHAR * fn;
L_CHAR * target[2];
MX_ENTRY * e;
XL_SEXP * ret;
XL_GETFILE * gf;
int i;

	ret = 0;

	fn = nl_copy_str(std_cm,"Get");
	target[0] = target[1] = 0;
	ret = get_path(target,&gf,file,s,fn);
	if ( get_type(ret) == XLT_ERROR )
		goto end;
	d_f_ree(fn);
	if ( l_strcmp(gf->mode,l_string(std_cm,"lod")) ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUPPORT_MODE,
			l_string(std_cm,"Get"),
			n_get_string("unsupport Get mode"));
	}

	for ( i = 0 ; i < 2 ; i ++ ) {
		if ( target[i] == 0 )
			break;

		e = open_mxread(0,target[i],0,MI_MODE_SERVER);
		if ( e == 0 )
			continue;
check_mx_entry(e);
		ret = get_mx_status(s_flag,e);
check_mx_entry(e);
		close_mx_entry(e);
		goto end;
	}
	if ( i == 2 ) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_OPEN_FILE,
			l_string(std_cm,"gmxStatus"),
			0);
	}
end:
	if ( target[0] )
		d_f_ree(target[0]);
	if ( target[1] )
		d_f_ree(target[1]);
	return ret;
}

XL_SEXP *
_gb_gmxStatus(int s_flag,XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * path_type;
MX_ENTRY * e;
XL_SEXP * filename;
XL_SEXP * ret;
L_CHAR * id;
	path_type = get_sf_attribute(sf,l_string(std_cm,"path-type"));
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( s_flag == 0 ) {
		if ( path_type == 0 )
			goto permission_error;
		if ( l_strcmp(path_type,l_string(std_cm,"absolute")) == 0 )
			goto permission_error;
		if ( id )
			goto permission_error;
	}
	if ( id ) {
		e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
		if ( e == 0 )
			goto inv_param2;
		ret = get_mx_status(s_flag,e);
		goto end;
	}
	filename = get_el(s,1);
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	if ( path_type == 0 )
		goto abs_path;
	if ( l_strcmp(path_type,l_string(std_cm,"absolute")) == 0 ) {
	abs_path:
		e = open_mxread(0,filename->string.data,0,MI_MODE_DIRECT);
		if ( e == 0 )
			goto open_err;
		ret = get_mx_status(s_flag,e);
		close_mx_entry(e);
	}
	else if ( l_strcmp(path_type,l_string(std_cm,"related")) == 0 ) {
		ret = open_status_related(s_flag,filename->string.data,s);
	}
	else if ( l_strcmp(path_type,l_string(std_cm,"network")) == 0 ) {
		e = open_mxread(filename->string.data,0,0,MI_MODE_SERVER);
		if ( e == 0 )
			goto open_err;
		ret = get_mx_status(s_flag,e);
		close_mx_entry(e);
	}
	else if ( l_strcmp(path_type,l_string(std_cm,"key")) == 0 ) {
		e = open_mxread(0,0,filename->string.data,MI_MODE_SERVER);
		if ( e == 0 )
			goto open_err;
		ret = get_mx_status(s_flag,e);
		close_mx_entry(e);
	}
	else	goto inv_param;
end:
	return ret;
open_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxStatus"),
		0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxStatus"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxStatus"),
		n_get_string("attribute:path-type"));
inv_param2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxStatus"),
		n_get_string("id value"));
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxStatus"),
		n_get_string("file path(path-type = absolute, id access in Env0 mode)"));
}

XL_SEXP *
gb_gmxStatus_n(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
	return _gb_gmxStatus(0,env,s,a,sf);
}

XL_SEXP *
gb_gmxStatus_s(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
	return _gb_gmxStatus(1,env,s,a,sf);
}


