/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef MEDIANCUT_H
#define MEDIANCUT_H

#include "gif.h"
#include "gif_rgb.h"

#ifndef	MEDIANCUT_THREAD_NUM
#define	MEDIANCUT_THREAD_NUM	5
#endif

#define MEDIANHIST_SHIFT   4
#define MEDIANHIST_SIZE    16

typedef struct ColorTree
{
	int type;
	int pos;
	struct ColorTree *left;
	struct ColorTree *right;
	int pal_index;
} ColorTree;

typedef struct RGBColorInfo
{
	int r_pos,  g_pos,  b_pos;
	int r_size, g_size, b_size;
	int pixel_count;
	struct ColorTree *tree;
} RGBColorInfo;

typedef struct MedianCutInfo
{
	RGB4	*col;
	int count;
	int size;
} MedianCutInfo;

/**/
int MedianCut(int *pData, int iWidth, int iHeight, ColorMap * cmap, unsigned char *pCode, int iWorkID);

/**/
int median_info_maxlen(RGBColorInfo *info);
int median_info_get_pixel_weit(RGBColorInfo *info);
int median_info_maxtype(RGBColorInfo *info);
#endif
