/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___MEMORY_ROUTINE_H___
#define ___MEMORY_ROUTINE_H___

#include	"avt.h"

#define GC_THREAD_HASH_SIZE	100
#define GC_LIST_HASH_SIZE	23


typedef struct mem {
	struct mem *	m_next;
	struct mem *	m_prev;
	long		m_flags;
#define M_GC		((long)0x80000000)
#define M_STACK		((long)0x40000000)
	long		m_size;
	char *		file;
	int		line;
} MEM;


#define MEM2PT(m)	((void*)((m)+1))
#define PT2MEM(pt)	(((MEM*)(pt))-1)


#define _TEST_AND_RESET(m)	\
	(((m)->m_flags &			\
			(M_GC)) ?		\
		(((m)->m_flags &= ~M_GC) , 1) :	\
		0				\
	)
#define _TEST_AND_SET(m)	\
	(	(m)->file = gc_file,		\
		(m)->line = gc_line,		\
								\
		((m)->m_flags & (M_GC)) ?			\
			1 :					\
			(((m)->m_flags |= M_GC) , 0)		\
	)

#define TEST_AND_RESET(m)	_TEST_AND_RESET(PT2MEM(m))
#define TEST_AND_SET(m)		_TEST_AND_SET(PT2MEM(m))
#define TEST_MEM(m)		(PT2MEM(m)->m_flags)

#define GC_HEADER	\
	if ( p == 0 )		\
		return;		\
	if ( TEST_AND_SET(p) )	\
		return;


typedef struct gc_list {
	struct gc_list *	next;
	void *			mem;
	void			(*gc)();
} GC_LIST;

typedef struct gc_stack {
	struct gc_stack *	parent;
	struct gc_list *	hash[GC_LIST_HASH_SIZE];
	char *			msg;
	int			count;
	struct gc_stack *	child;
	struct gc_thread *	thread;
} GC_STACK;

typedef struct gc_thread {
	struct gc_thread *	next;
	int			tid;
	GC_STACK *		stack;
	int			depth;
} GC_THREAD;

typedef struct ms_node {
	struct ms_node *	next;
	int			total_size;
	char *			file;
	int			line;
} MS_NODE;

#define MS_NODE_HASH_SIZE	20

typedef struct mem_statistics {
	AVT_NODE * 		root;
	MS_NODE *		hash[MS_NODE_HASH_SIZE];
	AVT_NODE		a[MS_NODE_HASH_SIZE];
	int			a_ptr;
} MEM_STATISTICS;


void * xx_mmalloc(unsigned long,void (*)(),char * file,int line);
#define mmalloc(size,func)	xx_mmalloc((size),(func),__FILE__,__LINE__)
void * mrealloc(void*,unsigned long,void (*)());
int mem_gc();
void gc_text(char*);

void gc_set_ptr(void * ptr,int (*gc_func)());
void gc_reset_ptr();
void gc_enable();
void gc_disenable();
void gc_permit();
void gc_permit_exit();

char * copy_mstr(char *);

void * min_malloc(int);
void * min_realloc(void*,int);
void min_free(void*);

GC_THREAD * _search_me(int * tidp,int * keyp);
GC_THREAD * _get_gc_my_thread();
GC_THREAD * get_gc_my_thread();
void _push_stack(GC_THREAD * t,char *msg);
void _pop_stack(GC_THREAD * t);
void _insert_gc_list(GC_STACK * st,void * s,void (*gc)());
int _delete_gc_list(GC_STACK * st,void * s);
void _gc_set(GC_THREAD * t,void * s,void (*gc)());
void gc_set(void * s,void (*gc)());
void gc_set_nl(void * s,void (*gc)());
void _gc_delete(GC_THREAD * t,void * s);
void _gc_push(GC_THREAD * t,void * s,void (*gc)(),char *);
void _gc_pop(GC_THREAD * t,void * s,void (*gc)());
void gc_push(void * s,void (*gc)(),const char *);
void gc_pop(void * s,void (*gc)());
void gc_delete(void * s);
void gc_delete_nl(void * s);
void resize_gc_mem_nl(void * old,void *_new);

void lock_mem();
void unlock_mem();
void minit();
void mfree(void * f);



extern char * gc_file;
extern int gc_line;

#define GC_POSITION	(gc_file = __FILE__,gc_line = __LINE__)
#define GC_POSITION_int(t)	(gc_file = __FILE__,gc_line = (t))
#define GC_POSITION_strint(s,t)	(gc_file = (s) , gc_line = (t))


void print_stack(char * str,int dp);
void print_th(char * str);
int get_stacktop_count();
void _delete_thread(GC_THREAD * t);
void gc_stack_top();
void _insert_gc_list_non_check(GC_STACK * st,void * s,void (*gc)());
int _delete_gc_list_pair(GC_STACK * st,void * s);
int _gc_search_stack(GC_STACK * st,void * s);
void gc_delete_pair(void * s);
void gc_search_stack(void * s);
void _gc_set_non_check(GC_THREAD * t,void * s,void (*gc)());
void gc_set_nl_non_check(void * s,void (*gc)());
void gc_set_non_check(void * s,void (*gc)());
void * _get_gc_check_point(GC_THREAD * t);
void _compare_gc_check_point(GC_THREAD * t,void * p,char * msg);

int _mem_gc(MEM_STATISTICS * ms);
void free_mem_statistics(MEM_STATISTICS * ms);
void mem_test(char * msg);
void _mem_debug1();
int get_ms_key(MEM * m);
void insert_mem_statistics(MEM_STATISTICS * ms,MEM * m);
int sort_trace(AVT_NODE * a,AVT_NODE ** ret);
int sort_cmp(MS_NODE * n1,MS_NODE * n2);
void sort_ms(MEM_STATISTICS * ms);



#endif
