/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___RS_CACHE_H___
#define ___RS__CACHE_H___

typedef struct rs_buf {
	RESOURCE *		r;
	L_CHAR *		url;
	XL_SEXP *		data;
	XL_SEXP *		meta;
	XL_SEXP *		lump;
	int			flags;
#define RSBF_MAP		0x00000001
	int			file_id;
} RS_BUF;

#define RSQ_RESOURCE		0x00000001
#define RSQ_DATA		0x00000002
#define RSQ_META		0x00000004
#define RSQ_LUMP		0x00000008

int
get_rs_resource_cache(RS_BUF * b,L_CHAR * url,int req_flags);
int
set_rs_resource_cache(RS_BUF * b);
void
flush_rs_cache();
void
purge_rs_cache(L_CHAR * url);
L_CHAR *
get_filepath_from_file_id(int id,char * prefix);


#endif

