/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_LAYOUT_H___
#define ___V_LAYOUT_H___


#include "v/v_types.h"

class VLayout
{
public:
	VLayout();
	~VLayout();
	
	void			layout_in_frame(VObject* obj, bool onlyMinSize=false, int child_index=0);
	void			layout_in_align_view(VObject* obj, bool vert, bool onlyMinSize=false);
	void			layout_in_table_view(VObject* obj, bool onlyMinSize=false);
	void			layout_in_split_view(
										VObject* obj,
										bool vert,
										unsigned short &pos,
										unsigned short &min,
										unsigned short &max,
										char child_status[2],
										bool onlyMinSize=false);
	
	void			set_margin(VSize tl, VSize br) { margin_tl = tl; margin_br = br; }
	void			shift_children(VSize s);
	void			do_layout(VObject* obj);

	const VSize&		parent_min_size() { return parentMinSize; }
	const VSize&		parent_size() { return parentSize; }
	int			nos_children() { return nosChildren; }
	VRect*			children_rect() { return childrenRect; }
	
	static void		mark(const VObject* obj);
	static void		unmark(const VObject* obj);
	static const VObject*	get_ancestor_window(const VObject* obj);
	
	static bool		need_layout() { return marked != 0; }
	static bool		layout_marked_window();
	
protected:
	void			enlarge_parent(VSize d);
	void			ensmall_parent(VSize d);

	VObjectStatus	sts;
	VSize			parentMinSize;
	VSize			parentSize;
	int			nosChildren;
	VRect*			childrenRect;
	VSize			margin_tl;
	VSize			margin_br;

	static VObjectList	*marked;
};


#endif
