/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_GB_QUERY_INDICATE_H___
#define ___V_GB_QUERY_INDICATE_H___


extern "C" {
#include	"gbgraph.h"
#include	"radar.h"
}

#include	"v/vobj_utils.h"
#include	"v/VMacro.h"
#include	"v/VButton.h"
#include	"v/VDraw.h"
#include	"v/VgbFlame.h"
#include	"v/VFocusView.h"
#include	"v/VScrollView.h"
#include	"v/VBackColorView.h"

//#include	"radar.h"


typedef struct _VgbQueryIndicateStatus {
	QUERY_THREAD *		qth_get;
	QUERY_THREAD *		qth_set;
	QUERY_THREAD *		qth_delete;
	QUERY_THREAD *		qth_replace;
	QUERY_THREAD *		qth_reset_focus;
	unsigned 		qth_focused:1;
	unsigned			dirty:1;
	VButton *		new_button;
	VButton *		del_button;
	VButton *		edit_button;
	VgbFlameStandard *	flame;
	VImage *		eye;
	VRect			eye_elr[2];
	VSysArgTranslator *	edit_event;
} VgbQueryIndicateStatus;

#define VSF_QINDICATE_QTH_GET		(1<<0)
#define VSF_QINDICATE_QTH_SET		(1<<1)
#define VSF_QINDICATE_QTH_DELETE	(1<<2)
#define VSF_QINDICATE_QTH_REPLACE	(1<<3)
#define VSF_QINDICATE_QTH_RESET_FOCUS	(1<<4)
#define VSF_QINDICATE_NEW_BUTTON	(1<<5)
#define VSF_QINDICATE_DEL_BUTTON	(1<<6)
#define VSF_QINDICATE_EDIT_BUTTON	(1<<7)
#define VSF_QINDICATE_FLAME		(1<<8)
#define VSF_QINDICATE_EYE		(1<<9)
#define VSF_QINDICATE_EDIT_EVENT	(1<<10)
#define VSF_QINDICATE_SCROLL		(1<<11)
#define VSF_QINDICATE_DIRTY_BIT		(1<<12)

#define VSF_QINDICATE_ALL		0x1fff

typedef struct qind_thread {
	struct qind_thread *		next;
	QUERY_THREAD *			qth;
	VBackColorView * 		obj;
	VCheckBox *			check_box;
	VexDraw *			eye_obj;
	VVAlignView *			eye_obj_base;
	VHAlignView *			base_obj;
	VVAlignView *			indicate_obj;
	unsigned			selected:1;
	INTEGER64			zonbie_time;

	struct _VgbQueryIndicateWork *	qw;
} QIND_THREAD;

typedef struct flame_ctl {
	struct flame_ctl *	next;
	int			op;
#define FC_SET			1
#define FC_INSERT		2
#define FC_DELETE		3
	int			id;
	QUERY_THREAD *		qth;
} FLAME_CTL;

typedef struct _VgbQueryIndicateWork {
	VVAlignView *		align_v;
	VScrollView *		scroll;
	VFocusView *		focus;
	VButton *		new_button;
	VButton *		del_button;
	VButton *		edit_button;
	VImage *		eye;
	VRect			elr[2];
	VgbFlameStandard *	flame;
	QIND_THREAD *		qind_th;
	VSysArgTranslator *	edit_event;
	int			qth_id;
	FLAME_CTL *		fctl;
	unsigned 		from_flame:1;
	VImage *		eye_imgs[2];

	VObject *		target_obj;
	unsigned		dirty:1;
	
} VgbQueryIndicateWork;

class VgbQueryIndicate : public VMacro
{
  public:
	enum { object_type = VO_GQIN };

	virtual unsigned	get_type() const { return object_type; }

	static VgbQueryIndicate*
	create(const VObjectStatus *s, int flags, VExError* err=0) {
		return create(s, flags, 0, err);
	}
	static VgbQueryIndicate*
	create(const VObjectStatus *s, int flags, void * arg, VExError* err) {
		return static_cast<VgbQueryIndicate*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_queryindicate_status(
				VgbQueryIndicateStatus *,
				int flags) const;
	virtual VExError set_queryindicate_status(
				const VgbQueryIndicateStatus *,
				int flags);
	static void copy_queryindicate_status(
				VgbQueryIndicateStatus * dest,
				VgbQueryIndicateStatus * src,
				int flags) {
		
		if ( flags &   VSF_QINDICATE_QTH_GET )
			dest->qth_get = copy_q_thread(src->qth_get);
		if ( flags &   VSF_QINDICATE_QTH_SET )
			dest->qth_set = copy_q_thread(src->qth_set);
		if ( flags &   VSF_QINDICATE_QTH_DELETE )
			dest->qth_delete = copy_q_thread(src->qth_delete);
		if ( flags &   VSF_QINDICATE_QTH_REPLACE )
			dest->qth_replace = copy_q_thread(src->qth_replace);
		if ( flags &   VSF_QINDICATE_QTH_RESET_FOCUS )
			dest->qth_reset_focus = copy_q_thread(src->qth_reset_focus);
		if ( flags &   VSF_QINDICATE_NEW_BUTTON )
			dest->new_button = src->new_button;
		if ( flags &   VSF_QINDICATE_DEL_BUTTON )
			dest->del_button = src->del_button;
		if ( flags &   VSF_QINDICATE_EDIT_BUTTON )
			dest->edit_button = src->edit_button;
		if ( flags &   VSF_QINDICATE_FLAME )
			dest->flame = src->flame;
		if ( flags &   VSF_QINDICATE_EYE ) {
			memcpy(dest->eye_elr,src->eye_elr,sizeof(dest->eye_elr));
			dest->eye = src->eye;
			v_image_ref(dest->eye);
		}
		if ( flags &   VSF_QINDICATE_EDIT_EVENT )
			dest->edit_event = copy_vsat(src->edit_event);
		if ( flags & VSF_QINDICATE_DIRTY_BIT )
			dest->dirty = src->dirty;
	}
	static void free_queryindicate_status(
				VgbQueryIndicateStatus * src) {
		
		free_query_thread(src->qth_get);
		free_query_thread(src->qth_set);
		free_query_thread(src->qth_delete);
		free_query_thread(src->qth_replace);
		free_query_thread(src->qth_reset_focus);
		if ( src->eye )
			v_image_unref(src->eye);
		if ( src->edit_event )
			free_VSysArgTranslator(VFLT_DELETE,src->edit_event);
	}

	virtual void _qind_new_handler();
	virtual void _qind_del_handler();
	virtual void _qind_edit_handler();
	virtual void _qind_event_handler(QUERY_THREAD *);
	void _back_color_handler(QIND_THREAD * qt);
	void _disable_focus_handler(bool when);
	void _qind_focus_command_status();
	void _focus();

  protected:

  	virtual ~VgbQueryIndicate();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual VExError create_do_out_of_lock(
			const VObjectStatus *,int flags,VObject * nmp,void * arg);
	virtual void	destroy_do(VObject*);
	virtual void	destroy_do_out_of_lock(VObject*);

  private:
	static VObject *internal_new(){
	VgbQueryIndicate * ret;
		ret = new VgbQueryIndicate();
		return ret;
	}
	VgbQueryIndicateWork	qw;
	void _exec_flame_ctl(VgbFlameStandard * f,FLAME_CTL * fc);
};




// ===================================
// CLIPBOARD FOR Q_THREAD



extern VIM VIM_VdataQThread;


class VdataQThread : public VdataXL
{
  public:

	VdataQThread(const L_CHAR *str,int * erp=0,bool valid=1);
	VdataQThread(const char *str,int * erp=0,bool valid=1);
	VdataQThread(const XL_SEXP * s,int * erp=0,bool valid=1);
	VdataQThread(const QUERY_THREAD * s,int * erp=0,bool valid=1);
	VdataQThread(Vdata * d,int * erp=0,bool valid=1);
	virtual ~VdataQThread();

	static bool clipboard_available(bool lock_flag=1);
	static VdataQThread * new_from_clipboard();

	virtual char * get_VdataString(int * erp=0);
	virtual L_CHAR * get_VdataLString(int * erp=0);
	virtual XL_SEXP * get_VdataXL(int * erp=0);
	virtual QUERY_THREAD * get_VdataQThread(int * erp=0);
  protected:
};






extern "C" XL_SEXP *
vobj_get_VgbQueryIndicate(XLISP_ENV * env,XL_SEXP * arg,XLISP_ENV * a,XL_SYM_FIELD * sf);
extern "C" char * VgbQueryIndicate_get_from_sf(
	VgbQueryIndicateStatus * q_sts,
	int* q_flags,
	XLISP_ENV* env,
	L_CHAR * filepath,
	XL_SYM_FIELD * sf,
	XL_SEXP * arg);
extern "C" void
free_VgbQueryIndicateStatus(VgbQueryIndicateStatus * q_sts);




#endif
