/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"

void er_panic(char*);

#define ALLOC_CATEGORY	24

typedef struct s_alloc_header {
	struct s_alloc_header *	next;
	int			size;
	int			category;
	int			dummy;
} S_ALLOC_HEADER;


S_ALLOC_HEADER * alloc_category_table[ALLOC_CATEGORY];

void *
s_alloc(int size)
{
int c;
S_ALLOC_HEADER * ret;
	size += sizeof(S_ALLOC_HEADER);
	for ( c = 0 ; size > (1<<c) ; c ++ );
	if ( c >= ALLOC_CATEGORY ) {
		ret = malloc(size);
		ret->size = size;
		ret->category = -1;
		ret->next = 0;
		return (void*)(ret+1);
	}
	ret = alloc_category_table[c];
	if ( ret == 0 ) {
		ret = malloc(1<<c);
		ret->size = size;
		ret->category = c;
		ret->next = 0;
		return (void*)(ret+1);
	}
	alloc_category_table[c] = ret->next;
	ret->size = size;
	return (void*)(ret+1);
}


void
s_free(void * ptr)
{
S_ALLOC_HEADER * aptr;
int c;
	aptr = (S_ALLOC_HEADER*)ptr;
	aptr --;
	if ( aptr->category < 0 ) {
		free(aptr);
		return;
	}
	if ( aptr->category >= ALLOC_CATEGORY )
		er_panic("s_free");
	c = aptr->category;
	aptr->next = alloc_category_table[c];
	alloc_category_table[c] = aptr;
}

void *
s_realloc(void * ptr,int size)
{
S_ALLOC_HEADER * aptr;
S_ALLOC_HEADER * new_ptr;
int c,c1;
int core_size;
void * ret;
	if ( ptr == 0 ) {
		ret =  s_alloc(size);
		memset(ret,0,size);
		return ret;
	}
	size += sizeof(S_ALLOC_HEADER);

	aptr = (S_ALLOC_HEADER*)ptr;
	aptr --;
	if ( aptr->category < 0 ) {
		aptr = realloc(aptr,size);
		return (void*)(aptr+1);
	}
	if ( aptr->category >= ALLOC_CATEGORY )
		er_panic("s_realloc");
	c = aptr->category;
	for ( c1 = 0 ; size > (1<<c1) ; c1 ++ );
	if ( c1 >= ALLOC_CATEGORY ) {
		aptr = realloc(aptr,size);
		aptr->category = -1;
		aptr->size = size;
		return (void*)(aptr+1);
	}
	if ( c1 <= c ) {
		if ( aptr->size < size )
			memset(((char*)aptr)+aptr->size,0,size - aptr->size);
		aptr->size = size;
		return (void*)(aptr+1);
	}
	new_ptr = alloc_category_table[c1];
	if ( new_ptr == 0 ) {
		new_ptr = malloc(1<<c1);
		new_ptr->category = c1;
	}
	else {
		alloc_category_table[c1] = new_ptr->next;
	}
	if ( aptr->size < size )
		core_size = aptr->size;
	else	core_size = size;
	memcpy(new_ptr+1,aptr+1,core_size - sizeof(S_ALLOC_HEADER));
	if ( size > core_size )
		memset(((char*)new_ptr)+core_size,0,size - core_size);
	new_ptr->size = size;
	s_free(aptr+1);
	return (void*)(new_ptr+1);
}




