/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<errno.h>
#include	"memory_debug.h"
#include	"change_endian.h"
#include	"pdb64.h"
#include	"filespace64.h"
#include	"favt64.h"
#include	"dtree64.h"
#include	"utils.h"


typedef struct acc64_pn_dtree_data {
	ACC64_HEADER	a;
	PN64_DTREE_DATA	d;
} ACC64_PN_DTREE_DATA;

void
change_endian_dtree64_data_to_host(PN64_DTREE_DATA * d)
{
int len;
int i;
	change_endian_header64(&d->h);
	len = (d->h.size - sizeof(d->h))/sizeof(U_INTEGER64);
	for ( i = 0 ; i < len ; i ++ ) {
		change_endian(d->data[i]);
	}
}

void
change_endian_dtree64_data_to_net(PN64_DTREE_DATA * d)
{
int len;
int i;
	len = (d->h.size - sizeof(d->h))/sizeof(INTEGER64);
	for ( i = 0 ; i < len ; i ++ ) {
		change_endian(d->data[i]);
	}
	change_endian_header64(&d->h);
}

void
dtree64_endian(DTREE64_NODE * n)
{
	change_endian(n->tree);
	change_endian(n->data);
}

int
dtree64_cmp(DTREE64_NODE * n1,DTREE64_NODE * n2)
{

	if ( n1->ch < n2->ch )
		return -1;
	if ( n1->ch > n2->ch )
		return 1;
	return 0;
}


FAVT64_ROOT *
alloc64_dtree(PDB64 * p,int type)
{
	return favt64_alloc_root(p,type|FAST_DTREE_ROOT,dtree64_endian);
}

int
data_segment64(FAVT64_ROOT * r,FAVT64_NODE * n,U_INTEGER64 old,U_INTEGER64 data)
{
DTREE64_NODE * dp;
ACC64_PN_DTREE_DATA * dd;
int len,i;
	dp = n->data;
	dd = read_filespace64(r->h.p,dp->data);
	if ( dd == 0 )
		return -1;
	change_endian_dtree64_data_to_host(&dd->d);
	if ( dd->d.h.type != PNT_DTREE_DATA ) {
		n->h.flags |= FAF_DIRTY;
		if ( old == 0 ) {
			dd = d_re_alloc(dd,PN64_DTREE_DATA_S(2)
				+sizeof(ACC64_HEADER));
			dd->d.h.type = PNT_DTREE_DATA;
			dd->d.h.size = PN64_DTREE_DATA_S(2);
			dd->d.data[0] = dp->data;
			dd->d.data[1] = data;
		}
		else if ( old == dp->data ) {
			dp->data = data;
			return 0;
		}
		else
			return -1;
	}
	else if ( old ) {
		len = (dd->d.h.size - sizeof(dd->d.h))/sizeof(U_INTEGER64);
		for ( i = 0 ; i < len ; i ++ ) {
			if ( dd->d.data[i] == old )
				break;
		}
		if ( i == len )
			return -1;
		dd->d.data[i] = data;
		change_endian_dtree64_data_to_net(&dd->d);
		write_filespace64(r->h.p,dd);
		d_f_ree(dd);
		return 0;
	}
	else {
		len = (dd->d.h.size - sizeof(dd->d.h))/sizeof(U_INTEGER64);
		dd = d_re_alloc(dd,PN64_DTREE_DATA_S(len+1)+sizeof(ACC64_HEADER));
		dd->d.h.size = PN64_DTREE_DATA_S(len+1);
		dd->d.data[len] = data;
		free_filespace64(r->h.p,dp->data);
		n->h.flags |= FAF_DIRTY;
	}
	dd->a.fofs = alloc_filespace64(r->h.p,&dd->d.h);
	change_endian_dtree64_data_to_net(&dd->d);
	write_filespace64(r->h.p,dd);
	d_f_ree(dd);
	return 0;
}

int
insert_dtree64(int * errp,
	FAVT64_ROOT * r,L_CHAR * str,U_INTEGER64 old,U_INTEGER64 data)
{
FAVT64_NODE * n;
DTREE64_NODE dn;
DTREE64_NODE * dp;

	for ( ; ; str ++ ) {
		dn.ch = *str;

		n = favt64_search(errp,r,root_node64(errp,r),&dn,dtree64_cmp,0);
		if ( n == 0 ) {
			dn.data = 0;
			dn.tree = 0;
			n = favt64_alloc_node(r,&dn,sizeof(dn));
			favt64_insert(errp,r,&r->node,n,dtree64_cmp,0);
		}
		dp = n->data;
		if ( str[1] == 0 ) {
			if ( dp->data )
				return data_segment64(r,n,old,data);
			if ( old && old != dp->data )
				return -1;
			dp->data = data;
			n->h.flags |= FAF_DIRTY;
			return 0;
		}
		if ( dp->tree ) {
			r = get_root64(errp,r->h.p,dp->tree,dtree64_endian);
			if ( r == 0 )
				er_panic("insert_dtree(1)");
		}
		else {
			r = favt64_alloc_root(
				r->h.p,FAT_DTREE_NODE,dtree64_endian);
			if ( r == 0 )
				er_panic("insert_dtree(2)");
			dp->tree = r->h.fofs;
			n->h.flags |= FAF_DIRTY;
		}
	}
}

int
delete_data_segment64(FAVT64_ROOT * r,FAVT64_NODE * n,U_INTEGER64 old)
{
DTREE64_NODE * dp;
ACC64_PN_DTREE_DATA * dd;
int len,i;
int j;
	dp = n->data;
	dd = read_filespace64(r->h.p,dp->data);
	if ( dd == 0 )
		return -1;
	change_endian_dtree64_data_to_host(&dd->d);
	if ( dd->d.h.type != PNT_DTREE_DATA ) {
		n->h.flags |= FAF_DIRTY;
		if ( old == 0 ) {
			dp->data = 0;
			return 0;
		}
		else if ( old == dp->data ) {
			dp->data = 0;
			return 0;
		}
		else
			return -1;
	}
	else if ( old ) {
		len = (dd->d.h.size - sizeof(dd->d.h))/sizeof(U_INTEGER64);
		for ( i = 0 ; i < len ; i ++ ) {
			if ( dd->d.data[i] == old )
				break;
		}
		if ( i == len )
			return -1;
		n->h.flags |= FAF_DIRTY;
		if ( len == 2 ) {
			dp->data = dd->d.data[1-i];
			free_filespace64(r->h.p,dd->a.fofs);
			d_f_ree(dd);
		}
		else {
			for ( j = i+1 ; j < len ; j ++ )
				dd->d.data[j-1] = dd->d.data[j];
			dd->d.h.size = PN64_DTREE_DATA_S(len-1);
			change_endian_dtree64_data_to_net(&dd->d);
			free_filespace64(r->h.p,dd->a.fofs);
			dd->a.fofs = alloc_filespace64(r->h.p,&dd->d.h);
			write_filespace64(r->h.p,dd);
			dp->data = dd->a.fofs;
			d_f_ree(dd);
		}
		return 0;
	}
	else {
		free_filespace64(r->h.p,dp->data);
		n->h.flags |= FAF_DIRTY;
		dp->data = 0;
	}
	return 0;
}

int
delete_dtree64(int * errp,
	FAVT64_ROOT * r,L_CHAR * str,U_INTEGER64 old)
{
FAVT64_NODE * n,*n2;
DTREE64_NODE dn;
DTREE64_NODE * dp;
int ret;
int len;
FAVT64_ROOT ** r_list;
FAVT64_NODE ** n_list;
int i,j;
	len = l_strlen(str);
	n_list = d_alloc(sizeof(FAVT64_NODE*)*len);
	memset(n_list,0,sizeof(FAVT64_NODE*)*len);
	r_list = d_alloc(sizeof(FAVT64_ROOT*)*len);
	memset(r_list,0,sizeof(FAVT64_ROOT*)*len);
	for ( i = 0 ; ; str ++ , i ++ ) {
		favt64_lock(&r->h);
		r_list[i] = r;
		dn.ch = *str;
		n = favt64_search(errp,r,root_node64(errp,r),&dn,dtree64_cmp,0);
		if ( n == 0 ) {
			ret = -1;
			goto err;
		}
		favt64_lock(&n->h);
		dp = n->data;
		n_list[i] = n;
		if ( str[1] == 0 ) {
			if ( dp->data == 0 ) {
				ret = -1;
				goto err;
			}
			ret = delete_data_segment64(r,n,old);
			if ( ret < 0 )
				goto err;
			if ( dp->data ) {
				ret = 0;
				goto err;
			}
			if ( dp->tree ) {
				ret = 0;
				goto err;
			}
			dn.ch = *str;
			n2 = favt64_delete(errp,r,&r->node,&dn,dtree64_cmp,0);
			if ( n2 == 0 )
				er_panic("delete_dtree(2)");
			favt64_free_node(n2);
			n_list[i] = 0;
			
			for ( j = i ; j > 0 ; j -- ) {
				str--;
				r = r_list[j];
				if ( r->node.fofs )
					break;
				favt64_free_root(r);
				r_list[j] = 0;
				dp = n_list[j-1]->data;
				dp->tree = 0;
				if ( dp->data )
					break;
				dn.ch = *str;
				r = r_list[j-1];
				n2 = favt64_delete(errp,r,&r->node,&dn,dtree64_cmp,0);
				if ( n2 == 0 )
					er_panic("delete_dtree(2)");
				favt64_free_node(n2);
				n_list[j-1] = 0;
			}
			ret = 0;
			goto err;
		}
		if ( dp->tree == 0 ) {
			ret = -1;
			goto err;
		}
		r = get_root64(errp,r->h.p,dp->tree,dtree64_endian);
		if ( r == 0 )
			er_panic("delete_dtree(1)");
	}
err:
	for ( i = 0 ; i < len ; i ++ ) {
		if ( r_list[i] )
			favt64_unlock(&r_list[i]->h);
		if ( n_list[i] )
			favt64_unlock(&n_list[i]->h);
	}
	return ret;
}

U_INTEGER64
search_dtree64(int * errp,int * sizep,
		FAVT64_ROOT * r,L_CHAR * str,int perfect_flag)
{
DTREE64_NODE dn;
DTREE64_NODE * dp;
FAVT64_NODE * n;
int size;
U_INTEGER64 ret;
	size = 0;
	ret = 0;
	for ( ; ; str ++ , size ++ ) {
//ss_printf("search_dtree64 loop %c\n",(char)str[0]);
		dn.ch = *str;
		n = favt64_search(errp,r,root_node64(errp,r),&dn,dtree64_cmp,0);
		if ( n == 0 ) {
			if ( perfect_flag )
				return 0;
			if ( sizep )
				*sizep = size;
			return ret;
		}
		dp = n->data;
		if ( str[1] == 0 ) {
			if ( sizep )
				*sizep = size+1;
		 	return dp->data;
		}
		if ( dp->tree == 0 ) {
			if ( perfect_flag )
				return 0;
			if ( sizep )
				*sizep = size+1;
			return dp->data;
		}
		ret = dp->data;
		r = get_root64(errp,r->h.p,dp->tree,dtree64_endian);
		if ( r == 0 )
			er_panic("search_dtree");
	}
}


int
dtree64_trace_func(int * errp,FAVT64_NODE * a,DTREE64_TRACE_WORK * w)
{
DTREE64_NODE * dp;
ACC64_PN_DTREE_DATA * dd;
int len;
int ret;
int i;
FAVT64_ROOT * r;

check_cache64("dtree_trace_func");

	dp = a->data;

	len = l_strlen(w->target);
	w->target = d_re_alloc(w->target,sizeof(L_CHAR)*(len+2));
	w->target[len] = dp->ch;
	w->target[len+1] = 0;
	if ( dp->data ) {
		dd = read_filespace64(w->p,dp->data);
		if ( dd == 0 )
			return -1;
		change_endian_dtree64_data_to_host(&dd->d);
		if ( dd->d.h.type != PNT_DTREE_DATA ) {
			change_endian_dtree64_data_to_host(&dd->d);
			ret = (*w->func)(dp->data,dd,w);
			if ( ret )
				goto end;
		}
		else {
			len = (dd->d.h.size - PN64_DTREE_DATA_S(0))/sizeof(U_INTEGER64);
			for ( i = 0 ; i < len ; i ++ ) {
				ret = (*w->func)(dd->d.data[i],0,w);
				if ( ret )
					goto end;
			}
		}
		d_f_ree(dd);
	}
	if ( dp->tree ) {
		r = get_root64(errp,w->p,dp->tree,dtree64_endian);
		if ( r == 0 )
			er_panic("search_dtree");
		ret = (*w->trace)(r,root_node64(errp,r),
				dtree64_trace_func,w);
	}
end:

	w->target[len] = 0;
 	return ret;
}

int
dtree64_trace_from_small(int * errp,
		FAVT64_ROOT * r,int (*func)(),void * work)
{
DTREE64_TRACE_WORK w;
int ret;
	w.func = func;
	w.w = work;
	w.p = r->h.p;
	w.trace = favt64_trace_from_small;
	w.target = d_alloc(sizeof(L_CHAR));
	w.target[0] = 0;
	ret = favt64_trace_from_small(errp,
		r,root_node64(errp,r),dtree64_trace_func,&w);
	d_f_ree(w.target);
	return ret;
}



int
dtree64_trace_from_large(int * errp,
		FAVT64_ROOT * r,int (*func)(),void * work)
{
DTREE64_TRACE_WORK w;

check_cache64("dtree_trace_from_large...");
	w.func = func;
	w.w = work;
	w.p = r->h.p;
	w.trace = favt64_trace_from_large;
	w.target = d_alloc(sizeof(L_CHAR));
	w.target[0] = 0;
check_cache64("dtree_trace_from_large...2");
	return favt64_trace_from_large(errp,
			r,root_node64(errp,r),dtree64_trace_func,&w);
}


