/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"memory_routine.h"
#include	"xl_zlib.h"


XL_SEXP *
xl_mxUncompressZ(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
void * mx_glay_compress_1(int * ,MATRIX_DH_SET * d1);
void * mx_glay_compress_2(int * ,MATRIX_DH_SET * d1);
void * mx_jpeg_compress_1(int * ,MATRIX_DH_SET * d1);
void * mx_jpeg_compress_2(int * ,MATRIX_DH_SET * d1);

void
init_mxUncomressZ(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxUncompressZ"),
		get_func_prim(xl_mxUncompressZ,FO_APPLICATIVE,0,2,2));
}



XL_SEXP *
xl_mxUncompressZ(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MATRIX_ALLOC_BLOCK_PARAM * d1;
MATRIX_TOKEN * t;
XL_SEXP * ret;
void * d;
MATRIX_ALLOC_BLOCK_PARAM p;
L_CHAR * _opt;
int opt;
char * ptr,* pp;
int p_size;
char type;
MATRIX_DATA_TYPE * tp;
XL_SEXP * dat;
	t = get_env_work(env);
	if ( t == 0 )
		return 0;
		

	_opt = get_sf_attribute(sf,l_string(std_cm,"opt"));
	if ( _opt == 0 )
		opt = 7;
	else	opt = atoi(n_string(std_cm,_opt));
	
	dat = get_el(s,1);
	if ( get_type(dat) != XLT_PAIR )
		goto type_missmatch;

	d1 = get_vdata_from_sexp(get_el(dat,2));
	if ( d1 == 0 ) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"mxUncompressZ"),
			List(n_get_string("invalid parameter"),
				get_el(s,1),
				-1));
		goto end;
	}

	pp = ptr = zlib_uncompress(
		&p_size,
		d1->block,
		d1->size);
	type = *ptr++;
	p_size --;
	
	tp = get_matrix_data_type(type);
	
	switch ( type ) {
	case MDT_BLOCK:
		p.block = ptr;
		p.size = p_size;
		d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&p,0,
				__FILE__,__LINE__);
		break;
	default:
		d = (*tp->convert_to_host)(tp,ptr,p_size,MD_MMALLOC,0,__FILE__,__LINE__);
		break;
	}
	d_f_ree(pp);

	ret = List(
		n_get_symbol("data"),
		get_sexp_from_dim_code(t->process_node->matrix,t->process_node->dim_code),
		get_ptr(d,gc_text),
		-1);
	goto end;

type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxUncompressZ"),
		0);
	goto end;
/*
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxUncompressZ"),
		n_get_string("invalid parameter in mxUncompressZ"));
	goto end;
*/
end:
	return ret;
}





