/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VgbFlame.h"


VExError
VgbFlame::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
  return initial_VExError(V_ER_NO_ERR,0,0);
}


VExError
VgbFlame::get_status(VObjectStatus * s,int flags) const
{
	return initial_VExError(V_ER_NOT_SUPPORT,flags,0);
}

VExError
VgbFlame::set_status(const VObjectStatus * s,int flags)
{
	return initial_VExError(V_ER_NOT_SUPPORT,flags,0);
}


VgbFlame::~VgbFlame()
{
}


VExError
VgbFlame::set_switch_status(const VgbFlameSwitchStatus * s,int flags)
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}

VExError
VgbFlame::get_switch_status(VgbFlameSwitchStatus * s,int flags) const
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}


VExError
VgbFlame::set_flame_status(
	const VgbFlameStatus * s,
	int flags)
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}




VExError
VgbFlame::get_flame_status(
	VgbFlameStatus * s,
	int flags) const
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}


void
VgbFlame::redraw(VRect * rect) const
{
}


VError
VgbFlame::drag(int type,VPoint start,VPoint end)
{
	return V_ER_NOT_SUPPORT;
}


VExError 
VgbFlame::get_coordinate_status(
	VgbFlameCoordinateStatus *,
	int flags) const
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}


VExError
VgbFlame::set_coordinate_status(
	const VgbFlameCoordinateStatus *,
	int flags)
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}


VExError
VgbFlame::get_radar_status(
	VgbFlameRadarStatus *,
	int flags) const
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}
	
VExError
VgbFlame::set_radar_status(
	VgbFlameRadarStatus *,
	int flags)
{
VExError err;
	err.code = V_ER_NOT_SUPPORT;
	err.subcode1 = 0;
	err.subcode2 = 0;
	return err;
}


VExError VgbFlame::create_do_out_of_lock(
		const VObjectStatus *,int flags,VObject * nmp,void * arg)
{
	return initial_VExError(V_ER_NO_ERR,0,0);
}




// ============= VdataTRACKBACK ==============


VIM VIM_VdataTRACKBACK = { &VIM_VdataXL , VDT_NONE };

int
check_trackback(XL_SEXP * q)
{
XL_SEXP * sym;

retry:
	if ( get_type(q) != XLT_PAIR ) {
		return -1;
	}
	sym = car(q);
	switch ( get_type(sym) ) {
	case XLT_SYMBOL:
		break;
	case XLT_PAIR:
		q = sym;
		goto retry;
	default:
		return -1;
	}
	if  ( l_strcmp(sym->symbol.data,l_string(std_cm,"trackback")) ) {
		return -1;
	}
	if ( get_type(get_el(q,1)) != XLT_STRING ) {
		return -1;
	}
	return 0;
}

VdataTRACKBACK::VdataTRACKBACK(const L_CHAR *lstr,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
VdataXL * xl;
XL_SEXP * q;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataTRACKBACK;
	xl = new VdataXL(lstr,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = xl->get_VdataXL(&err);
	if ( err < 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	if ( check_trackback(q) < 0 ) {
		delete xl;
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	mData = xl;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}


VdataTRACKBACK::VdataTRACKBACK(const char *str,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
VdataXL * xl;
XL_SEXP * q;
	if ( !valid )
		return;
	vdata_type = &VIM_VdataTRACKBACK;
	xl = new VdataXL(str,&err);
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return;
	}
	q = xl->get_VdataXL(&err);
	if ( err < 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	if ( check_trackback(q) < 0 ) {
		delete xl;
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	mData = xl;
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}

VdataTRACKBACK::VdataTRACKBACK(const XL_SEXP * s,int * erp,bool valid)
	: VdataXL((char*)0,0,0)
{
	if ( !valid )
		return;
	vdata_type = &VIM_VdataTRACKBACK;
	if ( check_trackback((XL_SEXP*)s) < 0 ) {
		err = -1;
		if ( erp )
			*erp = -1;
		return;
	}
	mData = new VdataXL(s,&err);
	if ( err < 0 ) {
		err = -1;
		if ( erp )
			*erp = err;
		return;
	}
	size = 0;
	err = 0;
	if ( erp )
		*erp = 0;
	return;
}


VdataTRACKBACK::VdataTRACKBACK(Vdata * d,int * erp,bool valid)
	: VdataXL((char*)0,0)
{
VIM * v;
VdataXL * xl;
XL_SEXP * _xl;
	if ( !valid )
		return;
	err = 0;
	vdata_type = &VIM_VdataTRACKBACK;
	v = d->get_type();
	switch ( cmp_VIM(v,&VIM_VdataTRACKBACK) ) {
	case 0:
	case 1:
		mData = (void*)static_cast<VdataTRACKBACK*>(d)->get_VdataTRACKBACK(&err);
		break;
	case -1:
		xl = new VdataXL(d,&err);
		if ( err < 0 ) {
			if ( erp )
				*erp = err;
			delete xl;
			return;
		}
		gc_push(0,0,"");
		_xl = xl->get_VdataXL();
		if ( check_trackback(_xl) ) {
			gc_pop(0,0);
			err = -1;
			if ( erp )
				*erp = err;
			delete xl;
			return;
		}
		gc_pop(0,0);
		mData = (void*)xl;
		if ( err < 0 ) {
			if ( erp )
				*erp = err;
			return;
		}
		break;
	default:
		err = -1;
		break;
	}
	if ( erp )
		*erp = err;
	if ( err < 0 )
		return;
}

VdataTRACKBACK::~VdataTRACKBACK()
{
VdataXL * xl;
	if ( this->get_type() != &VIM_VdataTRACKBACK )
		return;
	xl = (VdataXL*)mData;
	delete xl;
}

char*
VdataTRACKBACK::get_VdataString(int * erp)
{
VdataXL * _xl;
char * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	_xl = (VdataXL*)mData;
	ret = _xl->get_VdataString();
	if ( erp )
		*erp = 0;
	return ret;
}

L_CHAR*
VdataTRACKBACK::get_VdataLString(int * erp)
{
VdataXL * _xl;
L_CHAR * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	_xl = (VdataXL*)mData;
	ret = _xl->get_VdataLString();
	if ( erp )
		*erp = 0;
	return ret;
}

XL_SEXP*
VdataTRACKBACK::get_VdataXL(int * erp)
{
VdataXL * _xl;
XL_SEXP * ret;
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	_xl = (VdataXL*)mData;
	ret = _xl->get_VdataXL();
	if ( erp )
		*erp = 0;
	return ret;
}

VdataXL*
VdataTRACKBACK::get_VdataTRACKBACK(int * erp)
{
	if ( err < 0 ) {
		if ( erp )
			*erp = err;
		return 0;
	}
	return (VdataXL*)mData;
}


bool
VdataTRACKBACK::clipboard_available(bool lock_flag)
{
Vdata * d;
VdataTRACKBACK * d2;
int er;
bool ret;
ClipBoardList * c;
	if ( lock_flag )
		lock_task(cb_lock);
	ret = false;
	d2 = static_cast<VdataTRACKBACK*>(check_clipboard_variation(&VIM_VdataTRACKBACK));
	if ( d2 ) {
		ret = true;
		goto end;
	}
	c = get_clipboard();
	if ( c == 0 )
		goto end;
	d = c->target;
	if ( d == 0 )
		goto end;
	d2 = new VdataTRACKBACK(d,&er);
	if ( er < 0 )
		goto end;
	insert_clipboard_variation(c,d2);
	ret = true;
end:
	if ( lock_flag )
		unlock_task(cb_lock,"new_from_clipboard");
	return ret;
}

VdataTRACKBACK * 
VdataTRACKBACK::new_from_clipboard()
{
VdataTRACKBACK * ret;
	lock_task(cb_lock);
	if ( VdataTRACKBACK::clipboard_available(false) )
		ret = static_cast<VdataTRACKBACK*>(delete_clipboard_variation(&VIM_VdataTRACKBACK));
	else	ret = 0;
	unlock_task(cb_lock,"new_from_clipboard");
	return ret;
}



