/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_AtachAttribute();

void
init_AtachAttribute(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"AtachAttribute"),
		get_func_prim(xl_AtachAttribute,FO_APPLICATIVE,0,4,4));
}

XL_SEXP *
xl_AtachAttribute(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * exp,* f,* d;
XL_SEXP * sym;
XL_SYM_FIELD * sf;
	exp = get_el(s,1);
	f = get_el(s,2);
	d = get_el(s,3);
	switch ( get_type(exp) ) {
	case XLT_ERROR:
		return exp;
	case XLT_PAIR:
		break;
	case XLT_SYMBOL:
		sym = exp;
		exp = 0;
		break;
	default:
		goto type_missmatch;
	}
	sym = car(exp);
	switch ( get_type(sym) ) {
	case XLT_ERROR:
		return sym;
	case XLT_SYMBOL:
		break;
	default:
		goto param_error;
	}
	switch ( get_type(f) ) {
	case XLT_ERROR:
		return f;
	case XLT_STRING:
		break;
	default:
		goto type_missmatch;
	}
	switch ( get_type(d) ) {
	case XLT_ERROR:
		return d;
	case XLT_STRING:
		sf = set_sym_field(sym->symbol.field,
			f->string.data,
			d->string.data);
		sym = get_symbol(sym->symbol.data);
		sym->symbol.field = sf;
		break;
	case XLT_NULL:
		sf = set_sym_field(sym->symbol.field,
			f->string.data,0);
		sym = get_symbol(sym->symbol.data);
		sym->symbol.field = sf;
		break;
	default:
		goto type_missmatch;
	}
	if ( exp )
		return cons(sym,cdr(exp));
	else	return sym;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"AtachAttribute"),
		n_get_string("type missmatch"));
param_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"AtachAttribute"),
		n_get_string("then else parameter error"));
}

