/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"regular.h"
#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_RegCmp();

void
init_RegCmp(XLISP_ENV * env)
{
XL_SEXP * p;
	set_env(env,l_string(std_cm,"RegCmp"),
		p = get_func_prim(xl_RegCmp,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_RegCmp(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * rex;
XL_SEXP * str;
AUTOMATON * a1;
int ret,min_ptr,max_ptr;
	rex = get_sf_attribute(sf,l_string(std_cm,"rex"));
	if ( rex == 0 )
		goto param_error;
	str = get_el(s,1);
	if ( get_type(str) != XLT_STRING )
		goto type_missmatch;
	a1 = get_fa(rex);
	ret = parse_dfa_str(&min_ptr,&max_ptr,a1,str->string.data,0);
	free_automaton(a1);
	return List(
		get_integer(ret,0),
		get_integer(min_ptr,0),
		get_integer(max_ptr,0),
		-1);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"RegCmp"),
		n_get_string("type missmatch"));
param_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"RegCmp"),
		n_get_string("parameter error"));
}

