/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_NullRect();

void
init_NullRect(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"NullRect"),
		get_func_prim(xl_NullRect,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_NullRect(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * type;
L_CHAR * unit;
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	unit = get_sf_attribute(sf,l_string(std_cm,"unit"));
	if ( unit == 0 )
		unit = l_string(std_cm,"m");
	if ( type == 0 )
		goto null;
	if ( l_strcmp(type,l_string(std_cm,"zero")) == 0 )
		goto zero;
	else if ( l_strcmp(type,l_string(std_cm,"null")) == 0 )
		goto null;
zero:
	return List(
		List(	get_integer(0,unit),
			get_integer(0,unit),
			-1),
		List(	get_integer(0,unit),
			get_integer(0,unit),
			-1),
		-1);
null:
	return List(
		List(	get_integer(0,unit),
			get_integer(0,unit),
			-1),
		List(	get_integer(-1,unit),
			get_integer(-1,unit),
			-1),
		-1);
}

