/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"change_endian.h"
#include	"gbgraph.h"

void
change_endian_gb_point(GB_POINT * p)
{
	change_endian_f(p->x);
	change_endian_f(p->y);
}



void
change_endian_gb_rect(GB_RECT * r)
{
	change_endian_gb_point(&r->tl);
	change_endian_gb_point(&r->br);
}

void
change_endian_gb_color(GB_COLOR * c)
{
	change_endian_f(c->r);
	change_endian_f(c->g);
	change_endian_f(c->b);
	change_endian_f(c->t);
}

void
change_endian_l_char(L_CHAR * str)
{
	for ( ; *str ; str ++ ) {
		change_endian_i(*str);
	}
}

void
change_endian_gb_time(GB_TIME * t)
{
	change_endian_f(t->year);
}

