/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"memory_debug.h"
#include	"long_char.h"

typedef struct ascii_work {
	unsigned char	buf;
} ASCII_WORK;

void * open_ascii();
int close_ascii(unsigned char *,void *);
int ascii2int(L_CHAR *,void*,unsigned char);
int int2ascii(unsigned char *,void*,L_CHAR);

CODE_METHOD ascii_cm = {
	"ASCII",
	LCC_ASCII,
	0,
	2,
	0,
	{0,0},
	open_ascii,
	close_ascii,
	ascii2int,
	int2ascii,
	0,
};


void *
open_ascii()
{
ASCII_WORK * ret;
	ret = d_alloc(sizeof(ASCII_WORK),103);
	ret->buf = 0;
	return ret;
}

int
close_ascii(unsigned char * ret,void * work)
{
	d_f_ree(work);
	return 0;
}

int
ascii2int(L_CHAR * ret,void * _work,unsigned char ch)
{
L_CHAR _ch;

	_ch = ch&0x000000ff;
	*ret = _ch;
	return 1;
}

int
int2ascii(unsigned char * ret,void * _work,L_CHAR ch)
{
	if ( (ch&LCZM_1B_TYPE) == LCZ_1BC_ASCII ) {
		ret[0] = ch&0xff;
		return 1;
	}
	return 0;
}
