/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___WIN_FLAME_H___
#define ___WIN_FLAME_H___

#include	"gbview.h"

#define BACKGROUND_COLOR	COL(0x3ff,0x3ff,0x3ff)
#define BACKGROUND_COLOR_MID	COL(0x200,0x200,0x200)


/* win_flame flags */
#define WFF_FREE		0x00000001
#define WFF_SHORT_MH		0x00000002
#define WFF_RUN			0x00000004
#define WFF_ACTIVE		0x00000008
#define WFF_WAIT_BEND		0x00000010
#define WFF_RESIZE		0x00000020

#define WFF_DRAW_REQUEST	0x00000040

#define WFF_DIRTY		0x00000380
#define WFF_LUSTER_DIRTY	0x00000080
#define WFF_POLY_DIRTY		0x00000100
#define WFF_PLOT_DIRTY		0x00000200


#define WFF_LUSTER		0x00000400
#define WFF_POLY		0x00000800
#define WFF_PLOT		0x00001000

/* for drawing */

#define WFF_DRAW		0x10000000

/* win_flame modes */
/*
#define RDM_IDLE		0
#define RDM_SPIRAL		1
#define RDM_SPIRAL_COMPLETE	2
#define RDM_RESIZE		3
*/

#define W_E2D_LUSTER		1
#define W_E2D_POLY		0.3
#define W_E2D_PLOT		0.01

#define W_GLOBE_LUSTER		1.2
#define W_GLOBE_POLY		0.3
#define W_GLOBE_PLOT		0.01

typedef struct win_flame_table {
/*
	int			type;
#define WF_E2D			1
#define WF_E2D_PLOT		2

#define WF_GLOBE		4
#define WF_GLOBE_PLOT		5
*/
	short			geo_type;
		/* equal to GT_T_XX in resource.h */
	short			wf_type;
#define WFT_STD			1
#define WFT_PLOT		2
#define WFT_PART		3
#define WFT_MAX			4


	int (*f_new)

		(	struct win_flame_table * tbl,
			WF_ID *		ret_wfid,
			REAL1		v_reso,
			RESOURCE * 	draw,
			MAP_HISTORY * 	mh,
			GB_POINT	center,
			REAL1		rotate,
			REAL1		resolution);

	int (*f_move)

		(	struct win_flame * wf,
			VPOINT from,
			VPOINT to,
			void * ix);
	int (*f_exit)

		(	struct win_flame * wf);

	int (*f_change)

		(	struct win_flame_table * tbl,
			struct win_flame * wf);

	int (*f_flame_redraw)

		(	struct win_flame * 	wf);

	int (*f_dirty)

		(	struct win_flame *	wf,
			GB_RECT *		r,
			int			flags,
			int			mode);

	int (*f_overlay)

		(	struct win_flame *	wf,
			OV_ARG *		a);

	int (*f_zoom)

		(	struct win_flame * 	wf,
			int			w,
			int			h,
			int *			index_x,
			int *			index_y);

	int (*f_resize)

		(	struct win_flame *	wf);

	int (*f_rotate)

		(	struct win_flame *	wf,
			VPOINT *		ix);

} WIN_FLAME_TABLE;

typedef struct wf_lock_list {
	struct wf_lock_list *	next;
	int			tid;
} WF_LOCK_LIST;

typedef struct win_flame {
	struct win_flame *	next;
	WF_ID			id;
	WIN_FLAME_TABLE *	tbl;
	unsigned int		insert_time;

	int			lock;
	WF_LOCK_LIST *		lock_list;
	int			browse;
	int			aboat_count;
	int			flags;
	/* win_flame flags */
	REAL1			v_reso;
	MAP_HISTORY *		mh;
	RESOURCE *		draw;
	unsigned long *		pixels;

	/* movement during redraw */
	int			mov_flag;
	int			mov_x;
	int			mov_y;

	/* win_flame modes */

	int			rd_task;
	SYMBOL_INDICATE *	sym_i;

	int			pri_adj;
} WIN_FLAME;

typedef struct globe_move_t {
	VPOINT *		ix;
	MATRIX3D		rm;
	double			radius;
} GLOBE_MOVE_T;

WIN_FLAME * touch_wf();
int
new_win_flame(
	WF_ID *		ret_wfid,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution);
int exit_win_flame(WIN_FLAME * wf);
int win_flame_move(WIN_FLAME * wf,VPOINT from,VPOINT to,void * ix);
int change_win_flame(WIN_FLAME * wf,int geo_type,int wf_type);
int win_flame_redraw(WIN_FLAME * wf);
int _win_flame_dirty(WIN_FLAME * wf,GB_RECT * r,int flags,int mode);
int win_flame_dirty(WF_ID wfid,GB_RECT * r,int flags,int mode);
int win_flame_overlay(WIN_FLAME * wf,OV_ARG * a);
int win_flame_zoom(WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y);
int win_flame_resize(WIN_FLAME * wf);
int win_flame_rotate(WIN_FLAME * wf,VPOINT * ix);

WIN_FLAME * _get_wf_ptr(WF_ID id);

/*
extern WIN_FLAME_TABLE * wf_type_list[];
*/
extern WIN_FLAME_TABLE * wf_geo_type_list[GT_T_MAX][WFT_MAX];

RESOURCE * wf_get_mh(WF_ID id,MAP_HISTORY ** mhp);
RESOURCE * _wf_get_mh(WIN_FLAME * wf,MAP_HISTORY ** mhp);


#endif
