/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"

THREAD_BLOCK	tb[THREAD_BLOCK_SIZE];
THREAD_BLOCK *	tb_free_list;

extern SEM	block_lock;


void *
new_block()
{
THREAD_BLOCK * t;
	lock_task(block_lock);
	if ( tb_free_list == 0 )
		er_panic("new_block(1)");
	t = tb_free_list;
	tb_free_list = t->next;
	unlock_task(block_lock,"new_block");
	return (void*)t;
}

void
free_block(void * t)
{
THREAD_BLOCK * tt;
	lock_task(block_lock);
	tt = t;
	tt->next = tb_free_list;
	tb_free_list = tt;
	unlock_task(block_lock,"free_block");
}
