/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_GetElement();

void
init_GetElement(XLISP_ENV * env)
{
XL_SEXP * p;
	set_env(env,l_string(std_cm,"GetElement"),
		p = get_func_prim(xl_GetElement,FO_APPLICATIVE,0,3,-1));
	set_env(env,l_string(std_cm,"GE"),p);
}

XL_SEXP *
xl_GetElement(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * exp;
XL_SEXP * part, * r, * sym;
int len;
XL_SEXP * attr, * a, * a_name, * a_data;
XL_SYM_FIELD * sf;

	exp = get_el(s,1);
	part = get_el(s,2);
	switch ( get_type(exp) ) {
	case XLT_ERROR:
		return exp;
	case XLT_PAIR:
		break;
	case XLT_NULL:
		return 0;
	default:
		goto type_missmatch;
	}
	switch ( get_type(part) ) {
	case XLT_ERROR:
		return part;
	case XLT_INTEGER:
		len = list_length(exp);
		if ( len < 0 )
			return list_error(exp);
		if ( len <= part->integer.data )
			return 0;
		if ( 0 > part->integer.data )
			goto param_error;
		return get_el(exp,part->integer.data);
	case XLT_SYMBOL:
		len = list_length(exp);
		if ( len < 0 )
			return list_error(exp);
		attr = cdr(cdr(cdr(s)));
		for ( ; get_type(exp) ; exp = cdr(exp) ) {
			r = car(exp);
			switch ( get_type(r) ) {
			case XLT_ERROR:
				return r;
			case XLT_PAIR:
				sym = car(r);
				switch ( get_type(sym) ) {
				case XLT_ERROR:
					return sym;
				case XLT_SYMBOL:
					break;
				default:
					continue;
				}
				break;
			default:
				continue;
			}
			if ( l_strcmp(
					sym->symbol.data,
					part->symbol.data) )
				continue;
			for ( a = attr ; get_type(a) ; ) {
				a_name = car(a);
				a = cdr(a);
				if ( get_type(a) == 0 )
					break;
				a_data = car(a);
				a = cdr(a);
				switch ( get_type(a_name) ) {
				case XLT_ERROR:
					return a_name;
				case XLT_STRING:
					break;
				default:
					goto type_missmatch;
				}
				switch ( get_type(a_data) ) {
				case XLT_ERROR:
					return a_data;
				case XLT_STRING:
					break;
				default:
					goto type_missmatch;
				}
				for ( sf = sym->symbol.field;
						sf;
						sf = sf->next ) {
					if ( l_strcmp(sf->name,
						a_name->string.data) )
						continue;
					if ( l_strcmp(sf->data,
						a_data->string.data) )
						continue;
					goto ok;
				}
				goto next;
			ok:	{}
			}
			return r;
		next:	{}
		}
		return 0;
	default:
		goto type_missmatch;
	}
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetElement"),
		n_get_string("type missmatch"));
param_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"GetElement"),
		n_get_string("parameter error"));
}

