/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"pfc.h"


void
pfc_checkpoint(PFC * p)
{
unsigned int now;
int ret;
int d;
	if ( lock_pfc(p) < 0 )
		return;
	load_pfc(p);
	now = get_xltime();
	d = now - p->last_checkpoint;
	if ( p->interval*CHECKPOINT_RATE > d
			&& d < CHECKPOINT_RATE/p->target ) {
		unlock_pfc(p);
		return;
	}
	p->evaluation = p->accumulate/(double)(now-p->last_checkpoint);
	p->accumulate = 0;
	p->last_checkpoint = now;
	pfc_control(p,p->evaluation,d);
	ret = save_pfc(p);
	log_printf(LOG_MESSAGE,"PCC interval %i",p->interval);
	unlock_pfc(p);
	return;
}
