/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___KYOTODB_H___
#define ___KYOTODB_H___

#include	"long_char.h"
#include	"pdb.h"

#define NAME_SIZE	20
#define ID_SIZE		16

#define PNT_K_GROUP	0xff00

#define PNT_K_TABLE	(PNT_K_GROUP|1)
#define PNT_K_IDS	(PNT_K_GROUP|2)
#define PNT_K_POINTS	(PNT_K_GROUP|3)

#define FAT_K_NAME	0x100
#define FAT_K_IDS	0x102

typedef struct pn_k_table {
	PN_HEADER	h;
	L_CHAR		name[NAME_SIZE];
	unsigned int	ids;
	unsigned int	points;
} PN_K_TABLE;

typedef struct pn_k_ids {
	PN_HEADER	h;
	char		id[1][ID_SIZE];
} PN_K_IDS;

#define PN_K_IDS_S(x)	((int)&(((PN_K_IDS*)0)->id[x]))

typedef struct pn_k_points {
	PN_HEADER	h;
	GB_POINT	p[1];
} PN_K_POINTS;

#define PN_K_POINTS_S(x) ((int)&(((PN_K_POINTS*)0)->p[x]))

typedef struct acc_pn_k_table {
	ACC_HEADER	a;
	PN_K_TABLE	d;
} ACC_PN_K_TABLE;

typedef struct acc_pn_k_ids {
	ACC_HEADER	a;
	PN_K_IDS	d;
} ACC_PN_K_IDS;

typedef struct acc_pn_k_points {
	ACC_HEADER	a;
	PN_K_POINTS	d;
} ACC_PN_K_POINTS;

typedef struct ids_node {
	char		id[ID_SIZE];
	unsigned int	fofs;
} IDS_NODE;

PDB * p;
void dummy_endian();
int cmp_string();
extern unsigned int names_root,ids_root;
ACC_PN_K_IDS * get_ids(unsigned int);
ACC_PN_K_POINTS * get_points(unsigned int);

#endif
