/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___REGULAR_H___
#define ___REGULAR_H___

#include	"long_char.h"

typedef struct a_goto {
	_L_CHAR			from;
	_L_CHAR			to;
	struct a_state *	next_state;
} A_GOTO;

typedef struct a_state {
	struct a_state *	next;
	int			flags;
#define AF_INIT		0x00000001
#define AF_ACCEPT	0x00000002
#define AF_CHECK1	0x00000004
#define AF_CHECK2	0x00000008
	int			table_size;
	A_GOTO *		table;

	struct a_state *	work_state;
	struct a_state_set *	state_set;
} A_STATE;


typedef struct a_state_set {
	A_STATE *		state;
	struct a_state_set *	next;
} A_STATE_SET;

typedef struct automaton {
	A_STATE *		state_list;
} AUTOMATON;

A_STATE * search_state(AUTOMATON * a,int flags);
A_STATE * get_next_state(A_STATE * s,_L_CHAR ch);

AUTOMATON * get_fa(L_CHAR * str);
int parse_dfa_str(
	int * min_ptr,
	int * max_ptr,
	AUTOMATON * dfa,
	L_CHAR * str,
	int min_match_flag);


#endif


