/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"v.h"
#include	"long_char.h"

VDISPLAY * disp_list = 0;

extern char * display_key;

void
gbf_set_display_key(char * key)
{
int l;
	display_key = copy_str(key);
	l = strlen(key);
	if ( display_key[l] == '/' )
		display_key[l] = 0;
}

VDISPLAY *
gbf_open_disp(VERROR * err)
{
VDISPLAY * d;
int match;
int i,er;
int fbm;
char * dis;
char * z;
int s;
V_OPEN_WIN_S ow;

	d = d_alloc(sizeof(*d),155);
	d->font_flag = 0;
	d->next = disp_list;
	disp_list = d;

	if ( display_key == 0 ) {	
		fprintf(stderr,"gbfont directory not specified.\n");
		exit(1);
	}


	/* for string_pic usable character set search */

	d->wct = new_wct();
	d->font_work = new_wct();

	d->win_list = 0;

	gbf_init();

	gbf_get_font(&d->jisx0201,d,"jisx0201");
	gbf_get_font(&d->jisx0208_1978,d,"jisx0208_1978");
	gbf_get_font(&d->jisx0208_1983,d,"jisx0208_1983");
	gbf_get_font(&d->jisx0208_1990,d,"jisx0208_1990");
	gbf_get_font(&d->jisx0212_1990,d,"jisx0212_1990");
	gbf_get_font(&d->iso8859_1,d,"iso8859_1");
	gbf_get_font(&d->iso8859_2,d,"iso8859_2");
	gbf_get_font(&d->iso8859_3,d,"iso8859_3");
	gbf_get_font(&d->iso8859_4,d,"iso8859_4");
	gbf_get_font(&d->iso8859_5,d,"iso8859_5");
	gbf_get_font(&d->iso8859_6,d,"iso8859_6");
	gbf_get_font(&d->iso8859_7,d,"iso8859_7");
	gbf_get_font(&d->iso8859_8,d,"iso8859_8");
	gbf_get_font(&d->iso8859_9,d,"iso8859_9");
	gbf_get_font(&d->iso8859_10,d,"iso8859_10");
	gbf_get_font(&d->iso8859_11,d,"iso8859_11");
	gbf_get_font(&d->iso8859_12,d,"iso8859_12");
	gbf_get_font(&d->iso8859_13,d,"iso8859_13");
	gbf_get_font(&d->iso8859_14,d,"iso8859_14");
	gbf_get_font(&d->iso8859_15,d,"iso8859_15");

	/* latin-1 */

	fbm = 0;
	if ( d->iso8859_1.fontname ) {
		set_wct(d->font_work,
			0,
			LCZM_1B_TYPE,
			0,&d->iso8859_1);
		fbm |= LCB_ISO8859_1;
	}
	if ( d->iso8859_2.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_2,
			LCZM_1B_TYPE,
			0,&d->iso8859_2);
		fbm |= LCB_ISO8859_2;
	}
	if ( d->iso8859_3.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_3,
			LCZM_1B_TYPE,
			0,&d->iso8859_3);
		fbm |= LCB_ISO8859_3;
	}
	if ( d->iso8859_4.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_4,
			LCZM_1B_TYPE,
			0,&d->iso8859_4);
		fbm |= LCB_ISO8859_4;
	}
	if ( d->iso8859_5.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_5,
			LCZM_1B_TYPE,
			0,&d->iso8859_5);
		fbm |= LCB_ISO8859_5;
	}
	if ( d->iso8859_6.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_6,
			LCZM_1B_TYPE,
			0,&d->iso8859_6);
		fbm |= LCB_ISO8859_6;
	}
	if ( d->iso8859_7.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_7,
			LCZM_1B_TYPE,
			0,&d->iso8859_7);
		fbm |= LCB_ISO8859_7;
	}
	if ( d->iso8859_8.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_8,
			LCZM_1B_TYPE,
			0,&d->iso8859_8);
		fbm |= LCB_ISO8859_8;
	}
	if ( d->iso8859_9.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_9,
			LCZM_1B_TYPE,
			0,&d->iso8859_9);
		fbm |= LCB_ISO8859_9;
	}
	if ( d->iso8859_10.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_10,
			LCZM_1B_TYPE,
			0,&d->iso8859_10);
		fbm |= LCB_ISO8859_10;
	}
	if ( d->iso8859_13.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_13,
			LCZM_1B_TYPE,
			0,&d->iso8859_13);
		fbm |= LCB_ISO8859_13;
	}
	if ( d->iso8859_14.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_14,
			LCZM_1B_TYPE,
			0,&d->iso8859_14);
		fbm |= LCB_ISO8859_14;
	}
	if ( d->iso8859_15.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_15,
			LCZM_1B_TYPE,
			0,&d->iso8859_15);
		fbm |= LCB_ISO8859_15;
	}

	wct_latin(d->wct,fbm);

	/* jp domain font */

	fbm = 0;
	if ( d->jisx0201.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_JISX0201,
			LCZM_1B_TYPE,
			0,&d->jisx0201);
		fbm |= LCB_JISX0201;
	}
	if ( d->jisx0208_1978.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0208_1978,
			LCZM_2B_TYPE,
			0,&d->jisx0208_1978);
		fbm |= LCB_JISX0208_1978;
	}
	if ( d->jisx0208_1983.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0208_1983,
			LCZM_2B_TYPE,
			0,&d->jisx0208_1983);
		fbm |= LCB_JISX0208_1983;
	}
	if ( d->jisx0208_1990.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0208_1990,
			LCZM_2B_TYPE,
			0,&d->jisx0208_1990);
		fbm |= LCB_JISX0208_1990;
	}
	if ( d->jisx0212_1990.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0212_1990,
			LCZM_2B_TYPE,
			0,&d->jisx0212_1990);
		fbm |= LCB_JISX0212_1990;
	}
	wct_jp(d->wct,fbm);

	/* unicode */

	wct_unicode(d->wct);

	d->font_flag = 1;

	err->err1 = E_OK;
	return d;
}


