/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"

#include "svg2gb.h"

extern L_CHAR *unitname;
extern char * data_encoding;
extern CODE_METHOD *data_encoding_cm;
XL_SEXP * xl_OutputPP();

void
init_OutputPP(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"OutputPP"),
		get_func_prim(xl_OutputPP,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_OutputPP(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP *ss;
SVG2GB_CONTEXT *ctx;
L_CHAR *const_pp = l_string(std_cm, "pp");
L_CHAR *const_info = l_string(std_cm, "info");
SVG2GB_OUTPUTPP_INFO o;
int p;

extern GB_RECT minrect;
extern int lod_max;
extern int lod_min;
extern double max_resolution;
extern int point_nos;
L_CHAR * dotper;
XL_SEXP * ret;

	if ( point_nos == 0 )
		return 0;

	ctx = svg2gb_get_context();
	ss = car(s);

	o.filename_pp[0] = 0;
	o.filename_inf[0] = 0;
	for( ; sf; sf=sf->next){
		if( l_strcmp(sf->name, const_pp) == 0	){
			strcpy(o.filename_pp, n_string(std_cm, sf->data));
		}
		else if( l_strcmp(sf->name, const_info) == 0){
			strcpy(o.filename_inf, n_string(std_cm, sf->data));
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"unit")) == 0 ) {
			if ( unitname )
				d_f_ree(unitname);
			unitname = ll_copy_str(sf->data,123);
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"encoding")) == 0 )
						{
			if ( data_encoding )
				d_f_ree(data_encoding);
			data_encoding = ln_copy_str(std_cm,sf->data);
			data_encoding_cm = search_cm(data_encoding);
			if ( data_encoding_cm == 0 )
				goto encoding_error;
		}
	}
	if ( o.filename_inf[0] == 0 ) {
		for ( p = strlen(o.filename_pp)-1 ;
			p >= 0 &&
			o.filename_pp[p] != '/' ; 
			p -- );
		p ++;
		strcpy(o.filename_inf,&o.filename_pp[p]); 
		for ( p = strlen(o.filename_inf)-1 ;
			p >= 0 &&
			o.filename_inf[p] != '.' ; 
			p -- );
		if ( p < 0 )
			p = strlen(o.filename_inf);
		strcpy(&o.filename_inf[p],".inf");
	}


	gc_push(0,0,"svg2gb");
	setup_minrect();
	
	ss_printf("\nNUMMBERING...\n");
	numbering();
	ss_printf("INFORMATION...\n");
	
	output_info(&o);
	
	ss_printf("LOD CONTROL...\n");
	lod_control();
	
	ss_printf("MAKING TREE...\n");
	make_tree();
	ss_printf("SAVE PDB FILE...\n");
	
	save_pdb(&o);
	
	ss_printf("END\n");
	ss_printf("\tminrect = (%f %f)-(%f %f)\n",
		minrect.tl.x,
		minrect.tl.y,
		minrect.br.x,
		minrect.br.y);
	ss_printf("lod %i-%i\n",lod_min,lod_max);
	ss_printf("resolution = %lf\n",1/max_resolution);
	
	gc_pop(0,0);

	if ( unitname ) {
		dotper = d_alloc(
			sizeof(L_CHAR)*
			(l_strlen(unitname) + 10),
			2345);
		memcpy(dotper,l_string(std_cm,"dot/"),sizeof(L_CHAR)*4);
		memcpy(&dotper[4],unitname,
			(l_strlen(unitname)+1)*
			sizeof(L_CHAR));
	}
	else	dotper = 0;
	
	ret = List(
		List(n_get_symbol("point-nos"),
			get_integer(point_nos,0),
			-1),
		List(n_get_symbol("minrect"),
			get_floating(minrect.tl.x,unitname),
			get_floating(minrect.tl.y,unitname),
			get_floating(minrect.br.x,unitname),
			get_floating(minrect.br.y,unitname),
			-1),
		List(n_get_symbol("resolution"),
			get_floating(1/max_resolution,dotper),
			-1),
		List(n_get_symbol("lod"),
			get_integer(lod_min,0),
			get_integer(lod_max,0),
			-1),
		-1);
	if ( dotper )
		d_f_ree(dotper);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"OutputPP"),
		n_get_string("type missmatch"));
encoding_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"OutputPP"),
		n_get_string("encoding error"));
}
