/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"v.h"
#include	"long_char.h"

VDISPLAY * disp_list = nil;


void
v_set_display_key(char * key)
{
}

int
set_gb2m(unsigned int * table)
{
int i;
	for ( i = 0;  i < (1<<COL_BIT);  i++ )
		table[i] = i;
	return 0;
}

void
set_gb2m_mask_and_shift(V_MAP_TBL * tbl, short color_bit)
{
	switch (color_bit) {
	
	case 32 :
		tbl->pixel_bits = 32;
		tbl->red_shift = 16;
		tbl->green_shift = 8;
		tbl->blue_shift = 0;
		tbl->color_bit = 8;
		tbl->red_mask = 0xff0000;
		tbl->green_mask = 0xff00;
		tbl->blue_mask = 0xff;
		break;

	case 16 :
		tbl->pixel_bits = 16;
		goto set16;		

	default :
		tbl->pixel_bits = 0;
set16:
		tbl->red_shift = 10;
		tbl->green_shift = 5;
		tbl->blue_shift = 0;
		tbl->color_bit = 5;
		tbl->red_mask = 0x7c00;
		tbl->green_mask = 0x3e0;
		tbl->blue_mask = 0x1f;
		break;
	}
}

void v_get_font();

typedef struct v_open_disp_s {
	VDISPLAY *		ret;
	VERROR *		err;
} V_OPEN_DISP_S;

int
_v_open_disp(V_OPEN_DISP_S * buf)
{
VDISPLAY * d;
int fbm, i;
	d = d_alloc(sizeof(*d));
	d->font_flag = 0;
	d->next = disp_list;
	disp_list = d;
	
	d->wct = new_wct();
	d->font_work = new_wct();

	d->win_list = 0;

	v_get_font(&d->jisx0201,d,"jisx");
	v_get_font(&d->jisx0208_1978,d,0);
	v_get_font(&d->jisx0208_1983,d,0);
	v_get_font(&d->jisx0208_1990,d,"jisx");
	v_get_font(&d->jisx0212_1990,d,0);
	v_get_font(&d->iso8859_1,d,"latin-1");
	v_get_font(&d->iso8859_2,d,0);
	v_get_font(&d->iso8859_3,d,0);
	v_get_font(&d->iso8859_4,d,0);
	v_get_font(&d->iso8859_5,d,0);
	v_get_font(&d->iso8859_6,d,0);
	v_get_font(&d->iso8859_7,d,0);
	v_get_font(&d->iso8859_8,d,0);
	v_get_font(&d->iso8859_9,d,0);
	v_get_font(&d->iso8859_10,d,0);
	v_get_font(&d->iso8859_11,d,0);
	v_get_font(&d->iso8859_12,d,0);
	v_get_font(&d->iso8859_13,d,0);
	v_get_font(&d->iso8859_14,d,0);
	v_get_font(&d->iso8859_15,d,0);

	/* latin-1 */

	fbm = 0;
	if ( d->iso8859_1.fontname ) {
		set_wct(d->font_work,
			0,
			LCZM_1B_TYPE,
			0,&d->iso8859_1);
		fbm |= LCB_ISO8859_1;
	}
	if ( d->iso8859_2.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_2,
			LCZM_1B_TYPE,
			0,&d->iso8859_2);
		fbm |= LCB_ISO8859_2;
	}
	if ( d->iso8859_3.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_3,
			LCZM_1B_TYPE,
			0,&d->iso8859_3);
		fbm |= LCB_ISO8859_3;
	}
	if ( d->iso8859_4.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_4,
			LCZM_1B_TYPE,
			0,&d->iso8859_4);
		fbm |= LCB_ISO8859_4;
	}
	if ( d->iso8859_5.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_5,
			LCZM_1B_TYPE,
			0,&d->iso8859_5);
		fbm |= LCB_ISO8859_5;
	}
	if ( d->iso8859_6.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_6,
			LCZM_1B_TYPE,
			0,&d->iso8859_6);
		fbm |= LCB_ISO8859_6;
	}
	if ( d->iso8859_7.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_7,
			LCZM_1B_TYPE,
			0,&d->iso8859_7);
		fbm |= LCB_ISO8859_7;
	}
	if ( d->iso8859_8.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_8,
			LCZM_1B_TYPE,
			0,&d->iso8859_8);
		fbm |= LCB_ISO8859_8;
	}
	if ( d->iso8859_9.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_9,
			LCZM_1B_TYPE,
			0,&d->iso8859_9);
		fbm |= LCB_ISO8859_9;
	}
	if ( d->iso8859_10.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_10,
			LCZM_1B_TYPE,
			0,&d->iso8859_10);
		fbm |= LCB_ISO8859_10;
	}
	if ( d->iso8859_13.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_13,
			LCZM_1B_TYPE,
			0,&d->iso8859_13);
		fbm |= LCB_ISO8859_13;
	}
	if ( d->iso8859_14.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_14,
			LCZM_1B_TYPE,
			0,&d->iso8859_14);
		fbm |= LCB_ISO8859_14;
	}
	if ( d->iso8859_15.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_ISO8859_15,
			LCZM_1B_TYPE,
			0,&d->iso8859_15);
		fbm |= LCB_ISO8859_15;
	}

	wct_latin(d->wct,fbm);

	/* jp domain font */

	fbm = 0;
	if ( d->jisx0201.fontname ) {
		set_wct(d->font_work,
			LCZ_1BC_JISX0201,
			LCZM_1B_TYPE,
			0,&d->jisx0201);
		fbm |= LCB_JISX0201;
	}
	if ( d->jisx0208_1978.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0208_1978,
			LCZM_2B_TYPE,
			0,&d->jisx0208_1978);
		fbm |= LCB_JISX0208_1978;
	}
	if ( d->jisx0208_1983.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0208_1983,
			LCZM_2B_TYPE,
			0,&d->jisx0208_1983);
		fbm |= LCB_JISX0208_1983;
	}
	if ( d->jisx0208_1990.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0208_1990,
			LCZM_2B_TYPE,
			0,&d->jisx0208_1990);
		fbm |= LCB_JISX0208_1990;
	}
	if ( d->jisx0212_1990.fontname ) {
		set_wct(d->font_work,
			LCZ_2BC_JISX0212_1990,
			LCZM_2B_TYPE,
			0,&d->jisx0212_1990);
		fbm |= LCB_JISX0212_1990;
	}
	wct_jp(d->wct,fbm);

	/* unicode */

	wct_unicode(d->wct);

	d->font_flag = 1;

	buf->err->err1 = E_OK;
	buf->ret = d;
	return 0;
}


/*
int _err_handler(Display * dd,XErrorEvent * ev)
{
VDISPLAY * d;
char str[64];
	for ( d = disp_list ; d ; d = d->next )
		if ( d->d == dd )
			break;
	XGetErrorText(dd,ev->error_code,str,64);
	fprintf(stderr,"error Message = %s\n",str);
	fprintf(stderr,"serial = %d\n",ev->serial);
	fprintf(stderr,"error code = %d\n",ev->error_code);
	fprintf(stderr,"request code = %d\n",ev->request_code);

//	fprintf(stderr,"minor code = %d\n".ev->minor_code);

	return 0;
}
*/

VDISPLAY *
v_open_disp(VERROR * err)
{
V_OPEN_DISP_S v;
	v.err = err;
	v.ret = 0;
	//ms_do(_v_open_disp,&v,"v_open_disp");
	_v_open_disp(&v);
	return v.ret;
}
