/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<errno.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"lock_level.h"


#define SW_HASH_SIZE	100

SEM sw_lock;


SW_HASH * hash[SW_HASH_SIZE];


void
sw_init()
{
	sw_lock = new_lock(LL_SLEEP_WAKEUP);
}

void
sleep_task(unsigned int key,SEM s)
{
unsigned int kk;
SW_HASH * h;
	kk = key%SW_HASH_SIZE;
	lock_task(sw_lock);
	for ( h = hash[kk]; h ; h = h->next )
		if ( h->key == key ) {
			h->cnt ++;
			unlock_task(sw_lock,"sleep_task(1)");
			goto last;
		}

	h = new_block();
	h->key = key;
	h->cnt = 1;
	sem_init(&h->sem,0,1);
	sem_trywait(&h->sem);

	h->next = hash[kk];
	hash[kk] = h;
	unlock_task(sw_lock,"sleep_task(3)");
last:
	if ( s )
		unlock_task(s,"sleep_task(4)");
retry1:
	errno = 0;
	if ( sem_wait(&h->sem) ) {
		if ( errno == EINTR )
			goto retry1;
	}
	lock_task(sw_lock);
	h->cnt --;
	if ( h->cnt == 0 ) {
		sem_destroy(&h->sem);
		free_block(h);
	}
	unlock_task(sw_lock,"sleep_task(5)");
	return;
}


void
wakeup_task(unsigned int key)
{
unsigned int kk;
int i,cnt;
SW_HASH * h, ** hp;

	kk = key%SW_HASH_SIZE;
	lock_task(sw_lock);
	for ( hp = &hash[kk] ; *hp ; hp = &(*hp)->next )
		if ( (*hp)->key == key )
			goto next;
	unlock_task(sw_lock,"wakeup_task(1)");
	return;
next:
	h = *hp;
	*hp = h->next;
	for ( i = h->cnt ; i ; i -- )
		sem_post(&h->sem);
	unlock_task(sw_lock,"wakeup_task(2)");
}

