/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"u_math.h"
#include	"gbview.h"
#include	"win_flame.h"
#include	"resource.h"

extern GBVIEW_ENV env;



void
calc_pitch_ln(int flag)
{
GB_POINT pp;
REAL1 reso;
REAL1 x_sign,y_sign;

	if ( env.flame_base->draw->c.geometory_type & GT_A_X_REV ) 
		x_sign = -1;
	else	x_sign = 1;
	if ( env.flame_base->draw->c.geometory_type & GT_A_Y_REV )
		y_sign = 1;
	else	y_sign = -1;

	pp.x = ((REAL1)env.win_width)/2;
	pp.y = ((REAL1)env.win_height)/2;
	reso = 1;
	if ( flag == 0 ) {
		map_from_flame(
			&env.flame_base_display_map,
			&pp,
			&reso,
			1);
		env.flame_base_center = pp;
	}
       	env.flame_base_display_map.d.ln.reverse.org.x =
		(-(cos(env.flame_base_rotate)*env.win_width
				+
		  sin(env.flame_base_rotate)*env.win_height)
			/(2*env.flame_base_resolution)
		+ x_sign*env.flame_base_center.x) * x_sign;
	env.flame_base_display_map.d.ln.reverse.org.y =
		(-(-sin(env.flame_base_rotate)*env.win_width
				+
		  cos(env.flame_base_rotate)*env.win_height)
			/(2*env.flame_base_resolution)
		+ y_sign*env.flame_base_center.y) * y_sign;
	env.flame_base_display_map.d.ln.reverse.matrix[0][0] =
		cos(env.flame_base_rotate)/env.flame_base_resolution*x_sign;
	env.flame_base_display_map.d.ln.reverse.matrix[0][1] =
		sin(env.flame_base_rotate)/env.flame_base_resolution*x_sign;
	env.flame_base_display_map.d.ln.reverse.matrix[1][0] =
		-sin(env.flame_base_rotate)/env.flame_base_resolution*y_sign;
	env.flame_base_display_map.d.ln.reverse.matrix[1][1] =
		cos(env.flame_base_rotate)/env.flame_base_resolution*y_sign;

	env.flame_base_display_map.d.ln.forward.org.x =
		((REAL1)env.win_width)/2 -
		(cos(env.flame_base_rotate)*env.flame_base_center.x*x_sign
		- sin(env.flame_base_rotate)*env.flame_base_center.y*y_sign)*
			env.flame_base_resolution;
	env.flame_base_display_map.d.ln.forward.org.y =
		((REAL1)env.win_height)/2 -
		(sin(env.flame_base_rotate)*env.flame_base_center.x*x_sign
		+ cos(env.flame_base_rotate)*env.flame_base_center.y*y_sign)*
			env.flame_base_resolution;
	env.flame_base_display_map.d.ln.forward.matrix[0][0] =
		cos(env.flame_base_rotate)*env.flame_base_resolution*x_sign;
	env.flame_base_display_map.d.ln.forward.matrix[0][1] =
		-sin(env.flame_base_rotate)*env.flame_base_resolution*y_sign;
	env.flame_base_display_map.d.ln.forward.matrix[1][0] =
		sin(env.flame_base_rotate)*env.flame_base_resolution*x_sign;
	env.flame_base_display_map.d.ln.forward.matrix[1][1] =
		cos(env.flame_base_rotate)*env.flame_base_resolution*y_sign;

	env.flame_base_display_map.d.ln.forward_reso_rate = 1;
	env.flame_base_display_map.d.ln.reverse_reso_rate = 1;

	env.flame_base_display_map.type = MHT_LINEAR;
	env.flame_base_display_map.dir = MHD_REVERSE;
}

void
calc_pitch_pp(int flag)
{
GB_POINT pp;
REAL1 reso,phi;
REAL1 x_sign,y_sign;
RESOURCE * r;
int er;

	r = env.flame_base->draw;
	if ( r->c.geometory_type & GT_A_X_REV ) 
		x_sign = -1;
	else	x_sign = 1;
	if ( r->c.geometory_type & GT_A_Y_REV )
		y_sign = -1;
	else	y_sign = 1;
	env.flame_base_display_map.d.pp.forward_rate
		= conv_unit(&er,
			r->h.cu.uenv,
			1,
			r->h.cu.unit,
			l_string(std_cm,"rad"));

	if ( flag == 0 ) {
		pp.x = ((REAL1)env.win_width)/2;
		pp.y = ((REAL1)env.win_height)/2;
		reso = 1;
		map_from_flame(
			&env.flame_base_display_map,
			&pp,
			&reso,
			1);
		env.flame_base_center = pp;
	}


	env.flame_base_display_map.d.pp.lambda
		= env.flame_base_center.x * x_sign;
	env.flame_base_display_map.d.pp.phi
		= phi = env.flame_base_center.y * y_sign;

	phi = conv_unit(&er,
			r->h.cu.uenv,
			phi,
			r->h.cu.unit,
			l_string(std_cm,"rad"));
	reso = conv_unit(&er,
			r->h.cu.uenv,
			env.flame_base_resolution,
			reso_c_unit(&r->h.cu),
			l_string(std_cm,"dot/rad"));

       	env.flame_base_display_map.d.pp.reverse_sur.org.x =
		-(cos(env.flame_base_rotate)*env.win_width
				+
		  sin(env.flame_base_rotate)*env.win_height)
			/(2*reso);
	env.flame_base_display_map.d.pp.reverse_sur.org.y =
		-(-sin(env.flame_base_rotate)*env.win_width
				+
		  cos(env.flame_base_rotate)*env.win_height)
			/(2*reso);
	env.flame_base_display_map.d.pp.reverse_sur.matrix[0][0] =
		cos(env.flame_base_rotate)/reso;
	env.flame_base_display_map.d.pp.reverse_sur.matrix[0][1] =
		sin(env.flame_base_rotate)/reso;
	env.flame_base_display_map.d.pp.reverse_sur.matrix[1][0] =
		-sin(env.flame_base_rotate)/reso;
	env.flame_base_display_map.d.pp.reverse_sur.matrix[1][1] =
		cos(env.flame_base_rotate)/reso;

	env.flame_base_display_map.d.pp.reverse_vol[0][0] = 1;
	env.flame_base_display_map.d.pp.reverse_vol[0][1] = 0;
	env.flame_base_display_map.d.pp.reverse_vol[0][2] = 0;
	env.flame_base_display_map.d.pp.reverse_vol[1][0] = 0;
	env.flame_base_display_map.d.pp.reverse_vol[1][1] = cos(phi);
	env.flame_base_display_map.d.pp.reverse_vol[1][2] = -sin(phi);
	env.flame_base_display_map.d.pp.reverse_vol[2][0] = 0;
	env.flame_base_display_map.d.pp.reverse_vol[2][1] = sin(phi);
	env.flame_base_display_map.d.pp.reverse_vol[2][2] = cos(phi);


	env.flame_base_display_map.d.pp.forward_sur.org.x =
		((REAL1)env.win_width)/2;
	env.flame_base_display_map.d.pp.forward_sur.org.y =
		((REAL1)env.win_height)/2;
	env.flame_base_display_map.d.pp.forward_sur.matrix[0][0] =
		cos(env.flame_base_rotate)*reso;
	env.flame_base_display_map.d.pp.forward_sur.matrix[0][1] =
		-sin(env.flame_base_rotate)*reso;
	env.flame_base_display_map.d.pp.forward_sur.matrix[1][0] =
		sin(env.flame_base_rotate)*reso;
	env.flame_base_display_map.d.pp.forward_sur.matrix[1][1] =
		cos(env.flame_base_rotate)*reso;

	env.flame_base_display_map.d.pp.forward_vol[0][0] = 1;
	env.flame_base_display_map.d.pp.forward_vol[0][1] = 0;
	env.flame_base_display_map.d.pp.forward_vol[0][2] = 0;
	env.flame_base_display_map.d.pp.forward_vol[1][0] = 0;
	env.flame_base_display_map.d.pp.forward_vol[1][1] = cos(phi);
	env.flame_base_display_map.d.pp.forward_vol[1][2] = sin(phi);
	env.flame_base_display_map.d.pp.forward_vol[2][0] = 0;
	env.flame_base_display_map.d.pp.forward_vol[2][1] = -sin(phi);
	env.flame_base_display_map.d.pp.forward_vol[2][2] = cos(phi);

	env.flame_base_display_map.type = MHT_PP;
	env.flame_base_display_map.dir = MHD_REVERSE;

}

void
change_table(int geo_type)
{
WIN_FLAME * wf;
	for ( wf = env.flame ; wf ; wf = wf->next )
		change_win_flame(wf,geo_type,0);
}

void
calc_pitch(int flag)
{
	if ( env.flame_base == 0 || env.flame_base->draw == 0 )
		return;
	switch ( env.flame_base->draw->c.geometory_type & GT_T_MASK ) {
	case GT_T_2D:
		calc_pitch_ln(flag);
		change_table(GT_T_2D>>GT_T_SHIFT);
		break;
	case GT_T_GLOBE_SUR:
		calc_pitch_pp(flag);
		change_table(GT_T_GLOBE_SUR>>GT_T_SHIFT);
		break;
	default:
		er_panic("calc_pitch(1)");
	}
}

void
center_check()
{
	if ( env.flame_base_center.x > 151 )
		er_panic("center");
	printf("CENTER %f\n",env.flame_base_center.x);
}
