/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<math.h>
#include	"xl.h"
#include	"task.h"
#include	"lock_level.h"
#include	"win_flame.h"

#define BW_LOAD_MAX	100

extern GBVIEW_ENV env;
SEM	ls_lock;

void load_structure_tick();
void load_structure_task();

void
init_load_structure()
{
	ls_lock = new_lock(LL_LOAD_STRUCTURE);
	new_tick(load_structure_tick,1,0);
}

void
assert_ls(int flags)
{
	lock_task(ls_lock);
	env.ls_flags |= flags;
	wakeup_task((int)&env.ls_flags);
	unlock_task(ls_lock,"assert_ls");
}

int
check_assert(int flags)
{
int ret;
	lock_task(ls_lock);
	ret = env.ls_flags & flags;
	unlock_task(ls_lock,"check_assert");
	return ret;
}



void
load_structure_tick()
{
	if ( env.ls_task_cnt == 0 ) {
printf("TICK_CREATE\n");
		create_task(load_structure_task,0,0);
	}
}

void
load_structure_task()
{
BROWSE_WORK bw;
RESOURCE * c;
WIN_FLAME * wf;
GB_POINT pp;
REAL1 reso;
REAL1 n_reso,p_reso;
int retry;
int b_ret,bb_ret;
int ses;
XL_INTERPRETER * xli;
int no;
RESOURCE * draw;
WF_ID wfid;
extern WIN_FLAME * _get_wf_ptr();
GB_RECT win_r;

/*
printf("load structure %i\n",get_tid());
*/
	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	ses = open_session(SEST_OPTIMIZE);

	for ( ; ; ) {
		lock_task(ls_lock);
		if ( (env.ls_flags & LSF_ASSERT) || bb_ret ) {
			env.ls_flags &= ~LSF_ASSERT;
			wakeup_task((int)&env.ls_flags);
			unlock_task(ls_lock,"ls");
		}
		else {
/*
printf("ls sleep %i\n",get_tid());
*/
			if  ( env.ls_task_cnt > 2 ) {
				unlock_task(ls_lock,"aaa");
				return;
			}
			env.ls_task_cnt ++;
			sleep_task((int)&env.ls_flags,ls_lock);
/*
printf("ls wakeup %i\n",get_tid());
*/
			lock_task(ls_lock);
			env.ls_task_cnt --;
			env.ls_flags &= ~LSF_ASSERT;
			unlock_task(ls_lock,"ls_lock");

		}

		bb_ret = 0;

		for ( wfid = get_next_wfid(0) ; wfid ; 
				wfid = get_next_wfid(wfid)  ) {
			lock_task(env.wf_lock);
			wf = _get_wf_ptr(wfid);
			if ( wf == 0 ) {
				unlock_task(env.wf_lock,"ls");
				continue;
			}
			if ( wf->browse ) {
				unlock_task(env.wf_lock,"ls");
				continue;
			}
			if ( _win_lock(wf) < 0 ) {
				unlock_task(env.wf_lock,"ls");
				continue;
			}
			wf->browse = 1;
			unlock_task(env.wf_lock,"load_structure");
			bw.type = BWT_CHILDREN;
			bw.mh = 0;
			bw.base = wfid;
			bw.ses = ses;
			bw.load_max = BW_LOAD_MAX;

			win_r.tl.x = win_r.tl.y = 0;
			win_r.br.x = env.win_width;
			win_r.br.y = env.win_height;

			lock_task(env.wf_lock);

			set_surp(&bw.surp,&win_r,env.flame_base_resolution);
			map_from_flame(
				&env.flame_base_display_map,
				bw.surp.ptr,
				bw.surp.reso,
				SURP_NOS);
			if ( wf->mh ) {
				map_from_flame(wf->mh,bw.surp.ptr,bw.surp.reso,
						SURP_NOS);
			}
			draw = wf->draw;

			_win_unlock(wf);
			unlock_task(env.wf_lock,"load_structure_task");



			browse_resource(draw,&bw);


			wf_check_resource();

			if ( bw.load_max != BW_LOAD_MAX )
				win_flame_dirty(wfid,0,WFF_DIRTY,0);

			if ( bw.load_max == 0 )
				bb_ret = 1;

			lock_task(env.wf_lock);
			if ( _get_wf_ptr(wfid) == wf ) {
				_win_lock(wf);
				wf->browse = 0;

				_win_unlock(wf);
			}
			unlock_task(env.wf_lock,"load_structure");
		}
		wf_wakeup();
	}

	close_session(ses);
	close_self_interpreter();
}
