/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"gbview.h"

int
set_si_gbview(
	char * server,
	int active_flags,
	SI_GBVIEW * data)
{
SERVER_INFO si;
SI_GBVIEW * g;
	si.active_flags = SIA_NAME|SIA_DATA;
	si.name = server;
	if ( get_serverinfo(&si) )
		return -1;
	g = (SI_GBVIEW *)si.data;
	if ( g == 0 ) {
		g = d_alloc(sizeof(g));
		memset(g,0,sizeof(*g));
		si.name = server;
		si.data = (int)g;
		si.active_flags = SIA_NAME|SIA_DATA;
		if ( set_serverinfo(&si,SIC_SET_IF_ZERO,SIS_ALL) == -2 )
			d_f_ree(g);
	}
	if ( active_flags & SIG_DM_SCHED_TYPE )
		g->dm_sched_type = data->dm_sched_type;
	return 0;
}
