/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FAVT_H___
#define ___FAVT_H___

#define FAVT_CACHE_SIZE	100

typedef struct favt_header {
	struct favt_header *	next;
	struct favt_header * 	prev;
	PDB *			p;
	unsigned int		fofs;
	short			type;
	unsigned short		flags;
#define FAF_DIRTY	0x0001
#define FAF_LOCK	0x0002
} FAVT_HEADER;

typedef struct favt_ptr {
	unsigned int		fofs;
	int			type;
	void *			ptr;
	unsigned short		flags;
} FAVT_PTR;

typedef struct favt_node {
	FAVT_HEADER	h;
	FAVT_PTR	small;
	FAVT_PTR	large;
	FAVT_PTR *	parent;
	struct favt_root * root;
	int		level;
	int		data_len;
	void *		data;
} FAVT_NODE;

typedef struct favt_root {
	FAVT_HEADER	h;
	int		type;
	void		(*endian_func)();
	FAVT_PTR	node;
} FAVT_ROOT;

typedef struct bound_list {
	struct bound_list *	next;
	void *			data;
	int			data_len;
} BOUND_LIST;

FAVT_ROOT * favt_alloc_root(PDB *,int,void (*)());
FAVT_NODE * favt_alloc_node(FAVT_ROOT *,void *,int);
FAVT_NODE * favt_insert(FAVT_ROOT *,FAVT_PTR *,FAVT_NODE * ,int (*)());
FAVT_NODE * favt_delete(FAVT_ROOT *,FAVT_PTR *,void *,int (*)());
FAVT_NODE * favt_search(FAVT_ROOT * p,FAVT_NODE * a,void * data,int (*cmp)());
BOUND_LIST *
	favt_bound_search(FAVT_ROOT *,FAVT_NODE *,void *,void *,int (*)());
void free_bound_list(BOUND_LIST *);
FAVT_ROOT * get_root(PDB *,unsigned int,void (*)());
void favt_test(FAVT_ROOT * p,FAVT_NODE * a,int (*cmp)());
FAVT_NODE * root_node(FAVT_ROOT * r);
void favt_free_root(FAVT_ROOT * rt);
void favt_free_node(FAVT_NODE * rt);
int favt_trace_from_large(FAVT_ROOT * p,FAVT_NODE * a,int (*func)(),void * work);
int favt_trace_from_small(FAVT_ROOT * p,FAVT_NODE * a,int (*func)(),void * work);
void favt_lock(FAVT_HEADER *);
void favt_unlock(FAVT_HEADER *);

#endif
